#!/bin/sh
BASE_PATH=$(dirname $(realpath $0))
SERVICE_NAME="SBOM Manager"
PATH_TO_JAR="$BASE_PATH/../lib/sbom-manager.jar"
PID_PATH_NAME=/tmp/sbomm.pid
cat "$BASE_PATH/logo"
. "$BASE_PATH/vmoptions"
if [ ! -e $JAVA_EXE ];
        then
          echo "Please install java on your system or set correct java binary path on vmoptions file"
          exit 1
        else
          echo "use this java binary: $JAVA_EXE"
fi

if [ -f $PID_PATH_NAME ]; then
  PID=$(cat $PID_PATH_NAME)
  echo "$SERVICE_NAME stopping ..."
  kill "$PID"
  echo "$SERVICE_NAME stopped ..."
  rm $PID_PATH_NAME
fi

$JAVA_EXE $JAVA_OPTS -jar $PATH_TO_JAR >/dev/null 2>&1 &
echo $! >$PID_PATH_NAME
echo "$SERVICE_NAME started ..."
