/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.vulnerability.transformer;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.VertexUtils;
import com.castsoftware.sca.scar.server.vulnerability.domain.ScoreType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.dto.DetailedVulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.dto.ScoreView;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class VulnerabilityTransformer {
    public static @NonNull VulnerabilityView fromLight(@NonNull VulnerabilityVertex vertex) {
        return new VulnerabilityView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getVId(), vertex.getType(), vertex.getSeverity());
    }

    public static @NonNull DetailedVulnerabilityView fromFull(@NonNull VulnerabilityVertex vertex) {
        DetailedVulnerabilityView view = new DetailedVulnerabilityView(vertex.getId(), VertexUtils.encodeId((Vertex)vertex), vertex.getVId(), vertex.getType(), vertex.getSeverity());
        view.setDescription(vertex.getDescription());
        view.setPublished(Long.valueOf(vertex.getPublished().toEpochMilli()));
        vertex.getReferences().forEach(arg_0 -> ((DetailedVulnerabilityView)view).addReference(arg_0));
        vertex.getCwes().forEach(arg_0 -> ((DetailedVulnerabilityView)view).addCwe(arg_0));
        view.setScoreV2(VulnerabilityTransformer.from((String)vertex.getVector2(), (Map)vertex.getScores2()));
        view.setScoreV3(VulnerabilityTransformer.from((String)vertex.getVector3(), (Map)vertex.getScores3()));
        return view;
    }

    private static @NonNull ScoreView from(String vector, @NonNull Map<String, Double> scores) {
        ScoreView view = new ScoreView();
        view.setVector(vector);
        view.setBaseScore(scores.get(ScoreType.BASE.name()));
        view.setExploitabilityScore(scores.get(ScoreType.EXPLOITABILITY.name()));
        view.setImpactScore(scores.get(ScoreType.IMPACT.name()));
        return view;
    }

    @Generated
    private VulnerabilityTransformer() {
    }
}

