/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.vulnerability.service;

import com.castsoftware.sca.scar.server.kpi.handler.KPIComputer;
import com.castsoftware.sca.scar.server.nvd.requester.NvdRequester;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.scar.server.util.event.EventListener;
import com.castsoftware.sca.scar.server.vulnerability.dao.VulnerabilityDao;
import com.castsoftware.sca.scar.server.vulnerability.domain.ScoreType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import com.castsoftware.sca.scar.server.vulnerability.dto.CreateVulnerabilityRequest;
import com.castsoftware.sca.scar.server.vulnerability.dto.DetailedVulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.dto.UpdateVulnerabilityRequest;
import com.castsoftware.sca.scar.server.vulnerability.dto.VulnerabilityView;
import com.castsoftware.sca.scar.server.vulnerability.exception.AttachedVulnerabilityException;
import com.castsoftware.sca.scar.server.vulnerability.exception.DuplicateVulnerabilityException;
import com.castsoftware.sca.scar.server.vulnerability.exception.VulnerabilityExceptions;
import com.castsoftware.sca.scar.server.vulnerability.handler.SeverityComputer;
import com.castsoftware.sca.scar.server.vulnerability.service.VulnerabilityService;
import com.castsoftware.sca.scar.server.vulnerability.transformer.VulnerabilityTransformer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VulnerabilityService {
    private final VulnerabilityDao vulnerabilityDao;
    private final NvdRequester nvdRequester;
    private final KPIComputer kpiComputer;

    public VulnerabilityService(VulnerabilityDao vulnerabilityDao, NvdRequester nvdRequester, KPIComputer kpiComputer) {
        this.vulnerabilityDao = vulnerabilityDao;
        this.nvdRequester = nvdRequester;
        this.kpiComputer = kpiComputer;
    }

    public Collection<VulnerabilityView> getVulnerabilities() {
        return this.vulnerabilityDao.findAll().stream().sorted(this.sortByVId()).map(VulnerabilityTransformer::fromLight).collect(Collectors.toList());
    }

    public Collection<DetailedVulnerabilityView> getVulnerabilitiesWithDetails() {
        return this.vulnerabilityDao.findAll().stream().sorted(this.sortByVId()).map(VulnerabilityTransformer::fromFull).collect(Collectors.toList());
    }

    private Comparator<VulnerabilityVertex> sortByVId() {
        return Comparator.comparing(VulnerabilityVertex::getVId, String.CASE_INSENSITIVE_ORDER);
    }

    public DetailedVulnerabilityView getVulnerability(String id) {
        return this.vulnerabilityDao.findById(RequestUtils.decodeId((String)id)).map(VulnerabilityTransformer::fromFull).orElseThrow(() -> VulnerabilityExceptions.vulnerabilityNotFound((String)id));
    }

    public String createVulnerability(@NonNull CreateVulnerabilityRequest request) {
        this.vulnerabilityDao.findByVId(request.getVulId()).ifPresent(v -> {
            throw new DuplicateVulnerabilityException(v.getVId());
        });
        VulnerabilityVertex vertex = this.hydrate((UpdateVulnerabilityRequest)request, new VulnerabilityVertex(request.getVulId()));
        VulnerabilityVertex saved = (VulnerabilityVertex)this.vulnerabilityDao.save((Vertex)vertex);
        return RequestUtils.encodeId((String)saved.getId());
    }

    public void editVulnerability(String id, UpdateVulnerabilityRequest request) {
        VulnerabilityVertex vertex = (VulnerabilityVertex)this.vulnerabilityDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> VulnerabilityExceptions.vulnerabilityNotFound((String)id));
        this.hydrate(request, vertex);
        this.vulnerabilityDao.save((Vertex)vertex);
        this.kpiComputer.computeLinkedBomsVulnerabilityKPIBackground(vertex.getId(), new EventListener[0]);
    }

    public void deleteVulnerability(String id) {
        VulnerabilityVertex vertex = (VulnerabilityVertex)this.vulnerabilityDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> VulnerabilityExceptions.vulnerabilityNotFound((String)id));
        boolean hasEdges = this.vulnerabilityDao.findElementToVulnerabilityEdges(vertex.getId()).stream().findAny().isPresent();
        if (hasEdges) {
            throw new AttachedVulnerabilityException(id);
        }
        this.vulnerabilityDao.delete((Vertex)vertex);
    }

    public boolean deleteUnlinkedVulnerabilities() {
        return this.vulnerabilityDao.deleteUnlinked();
    }

    public Collection<String> getVulnerabilityTypes() {
        return Arrays.stream(VulnerabilityType.values()).map(Enum::name).collect(Collectors.toList());
    }

    public Collection<String> getVulnerabilitySeverities() {
        return Arrays.stream(VulnerabilityLevel.values()).map(Enum::name).collect(Collectors.toList());
    }

    public DetailedVulnerabilityView searchExternalForAutofill(@NonNull String name) {
        return Optional.ofNullable(this.nvdRequester.search(name)).orElseThrow(() -> VulnerabilityExceptions.vulnerabilityNotFound((String)name));
    }

    private VulnerabilityVertex hydrate(UpdateVulnerabilityRequest request, VulnerabilityVertex vertex) {
        Optional<UpdateVulnerabilityRequest> oRequest = Optional.ofNullable(request);
        oRequest.map(UpdateVulnerabilityRequest::getType).map(type -> switch (1.$SwitchMap$com$castsoftware$sca$scar$server$vulnerability$dto$UpdateVulnerabilityRequest$Type[type.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> VulnerabilityType.UNDEFINED;
            case 2 -> VulnerabilityType.CVE;
        }).map(Enum::name).ifPresent(arg_0 -> ((VulnerabilityVertex)vertex).setType(arg_0));
        vertex.setDescription(oRequest.map(UpdateVulnerabilityRequest::getDescription).orElse(""));
        vertex.setPublished(Instant.ofEpochMilli(oRequest.map(UpdateVulnerabilityRequest::getPublished).orElse(0L)));
        vertex.setReferences(oRequest.map(UpdateVulnerabilityRequest::getReferences).orElseGet(ArrayList::new));
        vertex.setCwes(oRequest.map(UpdateVulnerabilityRequest::getCwes).orElseGet(ArrayList::new));
        vertex.setVector2(oRequest.map(UpdateVulnerabilityRequest::getVectorV2).orElse(""));
        vertex.setVector3(oRequest.map(UpdateVulnerabilityRequest::getVectorV3).orElse(""));
        HashMap scores2 = new HashMap();
        oRequest.map(UpdateVulnerabilityRequest::getScoreBaseV2).ifPresent(s -> scores2.put(ScoreType.BASE.name(), s));
        oRequest.map(UpdateVulnerabilityRequest::getScoreExploitabilityV2).ifPresent(s -> scores2.put(ScoreType.EXPLOITABILITY.name(), s));
        oRequest.map(UpdateVulnerabilityRequest::getScoreImpactV2).ifPresent(s -> scores2.put(ScoreType.IMPACT.name(), s));
        vertex.setScores2(scores2);
        HashMap scores3 = new HashMap();
        oRequest.map(UpdateVulnerabilityRequest::getScoreBaseV3).ifPresent(s -> scores3.put(ScoreType.BASE.name(), s));
        oRequest.map(UpdateVulnerabilityRequest::getScoreExploitabilityV3).ifPresent(s -> scores3.put(ScoreType.EXPLOITABILITY.name(), s));
        oRequest.map(UpdateVulnerabilityRequest::getScoreImpactV3).ifPresent(s -> scores3.put(ScoreType.IMPACT.name(), s));
        vertex.setScores3(scores3);
        vertex.setSeverity(vertex.getType().equals(VulnerabilityType.CVE.name()) ? SeverityComputer.computeCVESeverity((VulnerabilityVertex)vertex).name() : oRequest.map(UpdateVulnerabilityRequest::getSeverity).map(severity -> switch (1.$SwitchMap$com$castsoftware$sca$scar$server$vulnerability$dto$UpdateVulnerabilityRequest$Severity[severity.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> VulnerabilityLevel.NONE;
            case 2 -> VulnerabilityLevel.LOW;
            case 3 -> VulnerabilityLevel.MEDIUM;
            case 4 -> VulnerabilityLevel.HIGH;
            case 5 -> VulnerabilityLevel.CRITICAL;
            case 6 -> VulnerabilityLevel.UNKNOWN;
        }).map(Enum::name).orElse(VulnerabilityLevel.UNKNOWN.name()));
        return vertex;
    }
}

