/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.vulnerability.handler;

import com.castsoftware.sca.scar.server.vulnerability.domain.ScoreType;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityVertex;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class SeverityComputer {
    public static VulnerabilityLevel computeCVESeverity(VulnerabilityVertex vertex) {
        return ((Map)Optional.ofNullable(vertex.getScores3()).orElse(new HashMap())).containsKey(ScoreType.BASE.name()) ? SeverityComputer.computeCVESeverityScore3((double)((Double)vertex.getScores3().get(ScoreType.BASE.name()))) : SeverityComputer.computeCVESeverityScore2((double)((Map)Optional.ofNullable(vertex.getScores2()).orElse(new HashMap())).getOrDefault(ScoreType.BASE.name(), -1.0));
    }

    public static VulnerabilityLevel computeCVESeverityScore2(double base) {
        return base < 0.0 ? VulnerabilityLevel.UNKNOWN : (base < 4.0 ? VulnerabilityLevel.LOW : (base < 7.0 ? VulnerabilityLevel.MEDIUM : (base <= 10.0 ? VulnerabilityLevel.HIGH : VulnerabilityLevel.UNKNOWN)));
    }

    public static VulnerabilityLevel computeCVESeverityScore3(double base) {
        return base < 0.0 ? VulnerabilityLevel.UNKNOWN : (base < 0.1 ? VulnerabilityLevel.NONE : (base < 4.0 ? VulnerabilityLevel.LOW : (base < 7.0 ? VulnerabilityLevel.MEDIUM : (base < 9.0 ? VulnerabilityLevel.HIGH : (base <= 10.0 ? VulnerabilityLevel.CRITICAL : VulnerabilityLevel.UNKNOWN)))));
    }

    public static Map<String, Double> severityStringToMapConverter(String severity) {
        Map<String, Double> result = new HashMap<String, Double>();
        try {
            result = Arrays.stream(severity.split("/")).map(s -> s.split(":")).collect(Collectors.toMap(e -> SeverityComputer.severityNameConverter((String)e[0]), e -> Double.parseDouble(e[1])));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static String severityNameConverter(String sn) {
        switch (sn) {
            case "b": {
                return ScoreType.BASE.name();
            }
            case "e": {
                return ScoreType.EXPLOITABILITY.name();
            }
            case "i": {
                return ScoreType.IMPACT.name();
            }
        }
        return null;
    }
}

