/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.vulnerability.domain;

import com.castsoftware.sca.scar.server.bom.structure.BOMClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityLevel;
import com.castsoftware.sca.scar.server.vulnerability.domain.VulnerabilityType;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class VulnerabilityVertex
extends Vertex<SCArVertexVisitor> {
    public VulnerabilityVertex(String vId) {
        this.setProperty("vId", (Object)vId, Predicates.notEmptyString());
    }

    public VulnerabilityVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public VClassDefinition definition() {
        return BOMClassDefinition.V.VVulnerability;
    }

    public String getVId() {
        return (String)this.getPropertyOrNull("vId");
    }

    public String getType() {
        return (String)this.getProperty("type", (Object)VulnerabilityType.UNDEFINED.name());
    }

    public void setType(String type) {
        this.setProperty("type", (Object)type, Predicates.notEmptyString());
    }

    public String getDescription() {
        return (String)this.getProperty("description", (Object)"");
    }

    public void setDescription(String description) {
        this.setProperty("description", (Object)description);
    }

    public List<String> getReferences() {
        return (List)this.getProperty("references", ArrayList::new);
    }

    public void setReferences(List<String> references) {
        this.setProperty("references", references);
    }

    public Instant getPublished() {
        return Instant.ofEpochSecond((Long)this.getProperty("published", (Object)0L));
    }

    public void setPublished(Instant instant) {
        Optional.ofNullable(instant).map(Instant::getEpochSecond).ifPresent(i -> this.setProperty("published", i));
    }

    public String getSeverity() {
        return (String)this.getProperty("severity", (Object)VulnerabilityLevel.UNKNOWN.name());
    }

    public void setSeverity(String severity) {
        this.setProperty("severity", (Object)severity, Predicates.notEmptyString());
    }

    public List<String> getCwes() {
        return (List)this.getProperty("cwes", ArrayList::new);
    }

    public void setCwes(List<String> cwes) {
        this.setProperty("cwes", cwes);
    }

    public String getVector2() {
        return (String)this.getProperty("vector2", (Object)"");
    }

    public void setVector2(String vector2) {
        this.setProperty("vector2", (Object)vector2);
    }

    public String getVector3() {
        return (String)this.getProperty("vector3", (Object)"");
    }

    public void setVector3(String vector3) {
        this.setProperty("vector3", (Object)vector3);
    }

    public Map<String, Double> getScores2() {
        return (Map)this.getProperty("scores2", HashMap::new);
    }

    public void setScores2(Map<String, Double> scores2) {
        this.setProperty("scores2", scores2);
    }

    public Map<String, Double> getScores3() {
        return (Map)this.getProperty("scores3", HashMap::new);
    }

    public void setScores3(Map<String, Double> scores3) {
        this.setProperty("scores3", scores3);
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }

    protected Boolean isValid(OVertexDocument vertex) {
        return Optional.ofNullable(vertex).filter(v -> v.getPropertyNames().contains("vId")).map(v -> (String)v.getProperty("vId")).filter(Predicates.notEmptyString()).isPresent();
    }
}

