/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util.task;

import com.castsoftware.sca.scar.server.util.task.Task;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class TaskRunnable<TASK extends Task>
implements Runnable {
    private final Supplier<TASK> getter;
    private final Function<String, TASK> transformer;
    private TASK prepared;

    public TaskRunnable(Supplier<TASK> getter) {
        this.getter = (Supplier)Guards.notNull(getter, IllegalArgumentException::new);
        this.transformer = null;
    }

    public TaskRunnable(Function<String, TASK> transformer) {
        this.getter = null;
        this.transformer = (Function)Guards.notNull(transformer, IllegalArgumentException::new);
    }

    public TaskRunnable(TASK task) {
        this.getter = null;
        this.transformer = null;
        this.prepared = (Task)Guards.notNull(task, IllegalArgumentException::new);
    }

    public TASK getPrepared() {
        return (TASK)((Task)Guards.notNull((Object)this.prepared, (Supplier)Suppliers.illegalState((String)"Must prepare runnable before get task")));
    }

    final void prepare(String executionId) {
        if (Objects.nonNull(this.prepared)) {
            return;
        }
        this.prepared = Optional.ofNullable(this.getter).map(Supplier::get).orElseGet(() -> Optional.ofNullable(this.transformer).map(t -> (Task)t.apply(executionId)).orElse(null));
    }
}

