/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util.task;

import com.castsoftware.sca.scar.server.util.task.Task;
import com.castsoftware.sca.scar.server.util.task.TaskEventListener;
import com.castsoftware.sca.scar.server.util.task.TaskRunnable;
import com.castsoftware.sca.scar.server.util.task.TaskUpdateListener;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;

public class TaskExecutor<TASK extends Task>
implements TaskEventListener {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(TaskExecutor.class);
    private final Set<TaskEventListener> listeners;
    private final ExecutorService executorService;
    private final Semaphore semaphore;
    private final Map<String, TASK> contexts = new HashMap();

    public TaskExecutor(ExecutorService executorService, Integer parallelExecution) {
        this.listeners = new HashSet();
        this.executorService = executorService;
        this.semaphore = new Semaphore(Objects.requireNonNullElse(parallelExecution, 1));
    }

    public void addListener(TaskEventListener listener) {
        Optional.ofNullable(listener).ifPresent(this.listeners::add);
    }

    public void removeListener(TaskEventListener listener) {
        Optional.ofNullable(listener).ifPresent(this.listeners::remove);
    }

    public String execute(TaskRunnable<TASK> runnable) {
        if (!this.semaphore.tryAcquire()) {
            LOGGER.warn("Executor is busy... please retry later");
            return null;
        }
        this.notify(broadcaster -> broadcaster.updateExecutorStatus(this.isBusy().booleanValue()));
        String ref = UUID.randomUUID().toString();
        runnable.prepare(ref);
        Task task = runnable.getPrepared();
        task.addListener((TaskUpdateListener)this);
        this.contexts.put(ref, task);
        this.executorService.submit(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOGGER.error("Execution fail", t);
                throw Exceptions.wrap((Throwable)t);
            }
            finally {
                Task finishTask = runnable.getPrepared();
                finishTask.removeListener((TaskUpdateListener)this);
                this.notify(b -> b.finish(finishTask));
                this.contexts.remove(ref, finishTask);
                this.semaphore.release();
                this.notify(b -> b.updateExecutorStatus(this.isBusy().booleanValue()));
            }
        });
        return ref;
    }

    public Map<String, TASK> getTasks() {
        return Collections.unmodifiableMap(this.contexts);
    }

    public <T extends Task> void update(T build) {
        this.notify(b -> b.update(build));
    }

    public <T extends Task> void finish(T build) {
        this.notify(b -> b.finish(build));
    }

    public void updateExecutorStatus(boolean busy) {
        this.notify(b -> b.updateExecutorStatus(busy));
    }

    public Boolean isBusy() {
        return this.semaphore.availablePermits() == 0;
    }

    private void notify(Consumer<TaskEventListener> broadcaster) {
        this.listeners.forEach(broadcaster);
    }
}

