/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class VertexUtils {
    public static String encodeId(Vertex<?> vertex) {
        return Opt.ofNullable(vertex).map(Vertex::getId).map(VertexUtils::encodeId).orElseThrow(IllegalArgumentException::new);
    }

    public static String encodeId(String vertexId) {
        return Opt.ofNullable((Object)vertexId).map(Normalizes::encodeBase64).orElseThrow(IllegalArgumentException::new);
    }

    public static String decodeId(String id) {
        return Normalizes.decodeBase64((String)id);
    }

    public static List<String> getFieldNames(Class<?> fieldClass) {
        return Arrays.stream(((Class)Guards.notNull(fieldClass)).getDeclaredFields()).map(f -> {
            try {
                return (String)f.get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    private VertexUtils() {
    }
}

