/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util;

import com.castsoftware.sca.scar.server.util.VersionUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class VersionUtils {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([-\\w.]+))?(?:\\+([-\\w.]+))?$");

    public static int compareVersions(@NonNull String version1, @NonNull String version2) {
        SemanticVersion v1 = VersionUtils.parseVersion((String)version1);
        SemanticVersion v2 = VersionUtils.parseVersion((String)version2);
        int majorCompare = Integer.compare(v1.major, v2.major);
        if (majorCompare != 0) {
            return majorCompare;
        }
        int minorCompare = Integer.compare(v1.minor, v2.minor);
        if (minorCompare != 0) {
            return minorCompare;
        }
        int patchCompare = Integer.compare(v1.patch, v2.patch);
        if (patchCompare != 0) {
            return patchCompare;
        }
        if (v1.preRelease == null && v2.preRelease != null) {
            return 1;
        }
        if (v1.preRelease != null && v2.preRelease == null) {
            return -1;
        }
        if (v1.preRelease != null) {
            return v1.preRelease.compareTo(v2.preRelease);
        }
        return 0;
    }

    public static boolean isNewerVersion(@NonNull String version1, @NonNull String version2) {
        return VersionUtils.compareVersions((String)version1, (String)version2) > 0;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull VersionUtils.SemanticVersion parseVersion(@NonNull String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String preRelease = matcher.group(4);
        return new SemanticVersion(major, minor, patch, preRelease);
    }

    @Generated
    private VersionUtils() {
    }
}

