/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util;

import com.castsoftware.sca.util.java.Consumers;
import java.io.IOException;
import java.util.Optional;

public final class SystemBrowsers {
    private static final String[] BROWSERS = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};

    public static void open(String url) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            Optional.of(url).filter(rt -> os.contains("win")).ifPresent(Consumers.forwardThrowable(SystemBrowsers::windows));
            Optional.of(url).filter(rt -> os.contains("mac")).ifPresent(Consumers.forwardThrowable(SystemBrowsers::macos));
            Optional.of(url).filter(rt -> os.contains("nix") || os.contains("nux")).ifPresent(Consumers.forwardThrowable(SystemBrowsers::linux));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SystemBrowsers() {
        throw new AssertionError();
    }

    private static void windows(String url) throws IOException {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    private static void macos(String url) throws IOException {
        Runtime.getRuntime().exec("open " + url);
    }

    private static void linux(String url) throws IOException {
        StringBuilder cmd = new StringBuilder();
        for (int i = 0; i < BROWSERS.length; ++i) {
            cmd.append(i == 0 ? "" : " || ").append(BROWSERS[i]).append(" \"").append(url).append("\" ");
        }
        Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd.toString()});
    }
}

