/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtils {
    private static final DateTimeFormatter DATE_TIME_DMY_SLASH_24H = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter DATE_YMD_SLASH = DateTimeFormatter.ofPattern("yyyy / MM / dd");
    private static final DateTimeFormatter DATE_TIME_YMD_COMPACT_24H = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    public static @NonNull String formatDmyDateTime24h(@NonNull Date date, @NonNull ZoneId zone) {
        return DateUtils.toZonedDateTime((Date)date, (ZoneId)zone).format(DATE_TIME_DMY_SLASH_24H);
    }

    public static @NonNull String formatDmyDateTime24h(@NonNull Date date) {
        return DateUtils.formatDmyDateTime24h((Date)date, (ZoneId)ZoneId.systemDefault());
    }

    public static @NonNull String formatExportDate(@NonNull Date date, @NonNull ZoneId zone) {
        return DateUtils.toZonedDateTime((Date)date, (ZoneId)zone).format(DATE_YMD_SLASH);
    }

    public static @NonNull String formatExportDate(@NonNull Date date) {
        return DateUtils.formatExportDate((Date)date, (ZoneId)ZoneId.systemDefault());
    }

    public static @NonNull String formatFileTimestamp(@NonNull Date date, @NonNull ZoneId zone) {
        return DateUtils.toZonedDateTime((Date)date, (ZoneId)zone).format(DATE_TIME_YMD_COMPACT_24H);
    }

    public static @NonNull String formatFileTimestamp(@NonNull Date date) {
        return DateUtils.formatFileTimestamp((Date)date, (ZoneId)ZoneId.systemDefault());
    }

    private static @NonNull ZonedDateTime toZonedDateTime(@NonNull Date date, @NonNull ZoneId zone) {
        return date.toInstant().atZone(zone);
    }

    @Generated
    private DateUtils() {
    }
}

