/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.user.service;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.sam.domain.SBomConfiguration;
import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.handler.SamLinkContext;
import com.castsoftware.sca.scar.server.sam.handler.SamUsageStatsUpdater;
import com.castsoftware.sca.scar.server.security.exception.BadCredentialsException;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import com.castsoftware.sca.scar.server.user.domain.UserPermission;
import com.castsoftware.sca.scar.server.user.domain.UserRoleType;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.scar.server.user.domain.UserVertex;
import com.castsoftware.sca.scar.server.user.exception.AssignedUserRoleException;
import com.castsoftware.sca.scar.server.user.exception.CannotAssignOwnerRoleException;
import com.castsoftware.sca.scar.server.user.exception.CannotModifyOwnerException;
import com.castsoftware.sca.scar.server.user.exception.CannotModifyRoleException;
import com.castsoftware.sca.scar.server.user.exception.DuplicateUserException;
import com.castsoftware.sca.scar.server.user.exception.DuplicateUserRoleException;
import com.castsoftware.sca.scar.server.user.exception.UserExceptions;
import com.castsoftware.sca.scar.server.user.model.DetailedUserRoleView;
import com.castsoftware.sca.scar.server.user.model.FullUserView;
import com.castsoftware.sca.scar.server.user.model.UserRoleView;
import com.castsoftware.sca.scar.server.user.model.request.ChangeUserPasswordRequest;
import com.castsoftware.sca.scar.server.user.model.request.CreateUserRequest;
import com.castsoftware.sca.scar.server.user.model.request.CreateUserRoleRequest;
import com.castsoftware.sca.scar.server.user.model.request.EditUserRequest;
import com.castsoftware.sca.scar.server.user.model.request.EditUserRoleRequest;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import com.castsoftware.sca.scar.server.user.transformer.UserRoleTransformer;
import com.castsoftware.sca.scar.server.user.transformer.UserTransformer;
import com.castsoftware.sca.scar.server.util.BeanValidatorUtil;
import com.castsoftware.sca.scar.server.util.RequestUtils;
import com.castsoftware.sca.util.java.Suppliers;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.crypto.password.PasswordEncoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserService {
    private static final Integer MAX_USERS_ALLOWED = 0;
    private final PasswordEncoder passwordEncoder;
    private final UserDao userDao;
    private final UserRoleDao userRoleDao;
    private final SamUsageStatsUpdater usageStatsFetcher;

    public UserService(PasswordEncoder passwordEncoder, UserDao userDao, UserRoleDao userRoleDao, SamUsageStatsUpdater usageStatsFetcher) {
        this.passwordEncoder = passwordEncoder;
        this.userDao = userDao;
        this.userRoleDao = userRoleDao;
        this.usageStatsFetcher = usageStatsFetcher;
    }

    public Collection<FullUserView> getUsers() {
        return this.userDao.findAllFullUsers().stream().map(UserTransformer::full).collect(Collectors.toList());
    }

    public FullUserView getUser(String id) {
        return this.userDao.findFullUserById(RequestUtils.decodeId((String)id)).map(UserTransformer::full).orElseThrow(() -> UserExceptions.userNotFound((String)id));
    }

    public String createUser(CreateUserRequest request) {
        BeanValidatorUtil.validate((Object)request);
        if (this.isUserLimitReached()) {
            throw new IllegalStateException("User creation limit exceeded");
        }
        this.userDao.findFullUserByEmail(request.getEmail()).ifPresent(user -> {
            throw new DuplicateUserException(user.getEmail());
        });
        UserRoleVertex userRole = (UserRoleVertex)this.userRoleDao.findById(RequestUtils.decodeId((String)request.getRoleId())).orElseThrow(IllegalArgumentException::new);
        UserVertex user2 = new UserVertex();
        user2.setEmail(request.getEmail());
        user2.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        user2.setEnabled(request.isEnabled());
        String userId = (String)this.userDao.getWithTransaction(session -> {
            UserVertex saved = (UserVertex)this.userDao.save((Vertex)user2, session);
            this.userDao.link((Vertex)user2, (Vertex)userRole, (EClassDefinition)UserClassDefinition.E.ERole, session);
            return RequestUtils.encodeId((String)saved.getId());
        });
        this.usageStatsFetcher.updateSamUsageStats();
        return userId;
    }

    private boolean isUserLimitReached() {
        Integer maxUsers = Optional.of(SamLinkContext.get()).map(SamLinkState::getSamAccount).map(SamAccount::getSbomConfiguration).map(SBomConfiguration::getMaxUsers).orElse(MAX_USERS_ALLOWED);
        Integer userCount = this.userDao.countAll().map(Long::intValue).orElseThrow(Suppliers.illegalState((String)"Cannot count registered Users"));
        return userCount >= maxUsers + 1;
    }

    public void editUser(String id, EditUserRequest request) {
        BeanValidatorUtil.validate((Object)request);
        UserVertex user = (UserVertex)this.userDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> UserExceptions.userNotFound((String)id));
        if (user.isOwner()) {
            throw new CannotModifyOwnerException();
        }
        UserRoleVertex userRole = (UserRoleVertex)this.userRoleDao.findById(RequestUtils.decodeId((String)request.getRoleId())).orElseThrow(IllegalArgumentException::new);
        if (UserService.isOwnerRole((UserRoleVertex)userRole)) {
            throw new CannotAssignOwnerRoleException();
        }
        if (!user.getEmail().equals(request.getEmail())) {
            this.userDao.findFullUserByEmail(request.getEmail()).ifPresent(u -> {
                throw new DuplicateUserException(u.getEmail());
            });
        }
        user.setEmail(request.getEmail());
        user.setEnabled(request.isEnabled());
        this.userDao.withTransaction(session -> {
            this.userDao.save((Vertex)user, session);
            this.userDao.unlinkAll((Vertex)user, (EClassDefinition)UserClassDefinition.E.ERole, session);
            this.userDao.link((Vertex)user, (Vertex)userRole, (EClassDefinition)UserClassDefinition.E.ERole, session);
        });
    }

    public void deleteUser(String id) {
        UserVertex user = (UserVertex)this.userDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> UserExceptions.userNotFound((String)id));
        if (user.isOwner()) {
            throw new CannotModifyOwnerException();
        }
        this.userDao.delete((Vertex)user);
        this.usageStatsFetcher.updateSamUsageStats();
    }

    public void changePassword(String id, ChangeUserPasswordRequest request) {
        BeanValidatorUtil.validate((Object)request);
        UserVertex user = (UserVertex)this.userDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> UserExceptions.userNotFound((String)id));
        if (!this.passwordEncoder.matches((CharSequence)request.getCurrent(), user.getPassword())) {
            throw new BadCredentialsException();
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        this.userDao.save((Vertex)user);
    }

    public Collection<DetailedUserRoleView> getDetailedUserRoles() {
        return this.userRoleDao.findAllDetailed().stream().map(UserRoleTransformer::detailed).collect(Collectors.toList());
    }

    public UserRoleView getUserRole(String id) {
        return this.userRoleDao.findById(RequestUtils.decodeId((String)id)).map(UserRoleTransformer::from).orElseThrow(() -> UserExceptions.userRoleNotFound((String)id));
    }

    public String createUserRole(CreateUserRoleRequest request) {
        BeanValidatorUtil.validate((Object)request);
        this.userRoleDao.findByName(request.getName()).ifPresent(role -> {
            throw new DuplicateUserRoleException(role.getName());
        });
        UserRoleVertex role2 = this.hydrate((EditUserRoleRequest)request, new UserRoleVertex());
        UserRoleVertex saved = (UserRoleVertex)this.userRoleDao.save((Vertex)role2);
        return RequestUtils.encodeId((String)saved.getId());
    }

    public void editUserRole(String id, EditUserRoleRequest request) {
        BeanValidatorUtil.validate((Object)request);
        UserRoleVertex userRole = (UserRoleVertex)this.userRoleDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> UserExceptions.userRoleNotFound((String)id));
        if (UserService.isOwnerRole((UserRoleVertex)userRole)) {
            throw new CannotModifyRoleException(userRole.getName());
        }
        if (!userRole.getName().equals(request.getName())) {
            this.userRoleDao.findByName(request.getName()).ifPresent(role -> {
                throw new DuplicateUserRoleException(role.getName());
            });
        }
        this.hydrate(request, userRole);
        this.userRoleDao.save((Vertex)userRole);
    }

    private UserRoleVertex hydrate(EditUserRoleRequest request, UserRoleVertex userRole) {
        Set permissions = request.getPermissions().stream().map(UserPermission::valueOfName).map(UserPermission::getName).collect(Collectors.toSet());
        userRole.setName(request.getName());
        userRole.setPermissions(permissions);
        return userRole;
    }

    public void deleteUserRole(String id) {
        UserRoleVertex userRole = (UserRoleVertex)this.userRoleDao.findById(RequestUtils.decodeId((String)id)).orElseThrow(() -> UserExceptions.userRoleNotFound((String)id));
        if (UserService.isSystemRole((UserRoleVertex)userRole)) {
            throw new CannotModifyRoleException(userRole.getName());
        }
        boolean isAssignedToExistingUsers = this.userRoleDao.findEdgesFromUser(userRole.getId()).stream().findAny().isPresent();
        if (isAssignedToExistingUsers) {
            throw new AssignedUserRoleException(id);
        }
        this.userRoleDao.delete((Vertex)userRole);
    }

    private static boolean isOwnerRole(UserRoleVertex userRole) {
        return UserRoleType.OWNER.name().equals(userRole.getType());
    }

    private static boolean isSystemRole(UserRoleVertex userRole) {
        return UserRoleType.OWNER.name().equals(userRole.getType()) || UserRoleType.DEFAULT.name().equals(userRole.getType());
    }
}

