/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.user.handler;

import com.castsoftware.sca.scar.server.core.exception.InvalidStateException;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.security.exception.BadCredentialsException;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import com.castsoftware.sca.scar.server.user.domain.UserPermission;
import com.castsoftware.sca.scar.server.user.domain.UserRoleType;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.scar.server.user.domain.UserVertex;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.security.crypto.password.PasswordEncoder;

public class OwnerWriter {
    private final UserDao userDao;
    private final UserRoleDao userRoleDao;
    private final PasswordEncoder passwordEncoder;

    public OwnerWriter(UserDao userDao, UserRoleDao userRoleDao, PasswordEncoder passwordEncoder) {
        this.userDao = userDao;
        this.userRoleDao = userRoleDao;
        this.passwordEncoder = passwordEncoder;
    }

    public void createOwnerAccount(String email, String password) {
        UserRoleVertex role = new UserRoleVertex();
        role.setName("Owner");
        role.setPermissions(Arrays.stream(UserPermission.values()).map(UserPermission::getName).collect(Collectors.toSet()));
        role.setType(UserRoleType.OWNER.name());
        UserVertex owner = new UserVertex();
        owner.setEmail(email);
        owner.setPassword(this.passwordEncoder.encode((CharSequence)password));
        owner.setEnabled(true);
        owner.setOwner(true);
        this.userDao.withTransaction(session -> {
            UserVertex savedOwner = (UserVertex)this.userDao.save((Vertex)owner, session);
            UserRoleVertex savedRole = (UserRoleVertex)this.userRoleDao.save((Vertex)role, session);
            this.userDao.link((Vertex)savedOwner, (Vertex)savedRole, (EClassDefinition)UserClassDefinition.E.ERole, session);
        });
    }

    public void ensureOwnerAccount(String email, String password) {
        this.userDao.findOwnerUser().ifPresentOrElse(owner -> {
            if (!owner.getEmail().equalsIgnoreCase(email)) {
                owner.setEmail(email);
                owner.setPassword(this.passwordEncoder.encode((CharSequence)password));
                this.userDao.save((Vertex)owner);
            }
            this.userDao.withTransaction(session -> {
                UserRoleVertex role = owner.getUserRole();
                role.setPermissions(Arrays.stream(UserPermission.values()).map(UserPermission::getName).collect(Collectors.toSet()));
                role.setType(UserRoleType.OWNER.name());
                this.userRoleDao.save((Vertex)role, session);
            });
        }, () -> this.createOwnerAccount(email, password));
    }

    public void resetOwnerAccount(String email, String password) {
        UserVertex owner = (UserVertex)this.userDao.findOwnerUser().orElseThrow(() -> new InvalidStateException("WTF", "WTF ? no owner"));
        if (!owner.getEmail().equalsIgnoreCase(email)) {
            throw new BadCredentialsException();
        }
        owner.setEmail(email);
        owner.setPassword(this.passwordEncoder.encode((CharSequence)password));
        this.userDao.save((Vertex)owner);
    }
}

