/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.user.domain;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.castsoftware.sca.util.java.Predicates;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Optional;

public class UserVertex
extends Vertex<SCArVertexVisitor> {
    public UserVertex() {
    }

    public UserVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public VClassDefinition definition() {
        return UserClassDefinition.V.VUser;
    }

    public void accept(SCArVertexVisitor visitor) {
        visitor.visit(this);
    }

    public String getEmail() {
        return (String)this.getPropertyOrNull("email");
    }

    public void setEmail(String email) {
        this.setProperty("email", (Object)email, Predicates.notEmptyString());
    }

    public String getPassword() {
        return (String)this.getPropertyOrNull("password");
    }

    public void setPassword(String password) {
        this.setProperty("password", (Object)password, Predicates.notEmptyString());
    }

    public boolean isEnabled() {
        return (Boolean)this.getProperty("enabled", (Object)true);
    }

    public void setEnabled(boolean enabled) {
        this.setProperty("enabled", (Object)enabled);
    }

    public boolean isOwner() {
        return (Boolean)this.getProperty("owner", (Object)false);
    }

    public void setOwner(boolean owner) {
        this.setProperty("owner", (Object)owner);
    }

    protected Boolean isValid(OVertexDocument vertex) {
        return Optional.ofNullable(vertex).filter(v -> v.getPropertyNames().contains("email")).map(v -> (String)v.getProperty("email")).filter(Predicates.notEmptyString()).isPresent();
    }
}

