/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.user.dao;

import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.domain.FullUserVertex;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.scar.server.user.domain.UserVertex;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Guards;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectWhereStep;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserDao
extends GraphDao<UserVertex> {
    public UserDao(ODatabasePool oDatabasePool) {
        super(oDatabasePool, (VClassDefinition)UserClassDefinition.V.VUser);
    }

    public Optional<Long> countAll() {
        return (Optional)this.query(session -> session.query(this.queryBuilder.selectCount().from(this.definition.name()).toString(), new Object[0]).stream().map(o -> (Long)o.getProperty("count(*)")).findFirst());
    }

    public Collection<FullUserVertex> findAllFullUsers() {
        return new ArrayList<FullUserVertex>(this.selectFromUsers((Select)this.queryBuilder.selectFrom(this.definition.name())));
    }

    public Optional<FullUserVertex> findFullUserByEmail(String email) {
        return this.selectFromUsers((Select)this.queryBuilder.selectFrom(this.definition.name()).where(Fields.EMAIL.eq((Object)Guards.notBlank((String)email)))).stream().findFirst();
    }

    public Optional<FullUserVertex> findFullUserById(String id) {
        return this.selectFromUsers((Select)this.queryBuilder.selectFrom(this.definition.name()).where(GraphDao.MetaFields.rid.eq((Object)Guards.notBlank((String)id)))).stream().findFirst();
    }

    private Collection<FullUserVertex> selectFromUsers(Select<Record> selectUsers) {
        String traverseEdge = UserDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED_EDGE.value(new String[]{UserClassDefinition.E.ERole.name()}), (String)("(" + selectUsers.toString() + ")"), (Integer)1);
        String traverseRole = UserDao.traverse((String)GraphDao.TraverseType.IN_DEFINED_VERTEX.value(new String[]{UserClassDefinition.V.VUserRole.name()}), (String)traverseEdge, (Integer)2);
        SelectWhereStep query = this.queryBuilder.selectFrom(traverseRole);
        return this.getFullUsers((Query)query);
    }

    public Optional<FullUserVertex> findOwnerUser() {
        SelectConditionStep selectOwner = this.queryBuilder.selectFrom(UserClassDefinition.V.VUserRole.name()).where(Fields.ROLE_TYPE.eq((Object)"OWNER"));
        String traverseRole = UserDao.traverse((String)GraphDao.TraverseType.IN_DEFINED_EDGE.value(new String[]{UserClassDefinition.E.ERole.name()}), (String)("(" + selectOwner.toString() + ")"), (Integer)2, (boolean)true);
        String traverseUser = UserDao.traverse((String)GraphDao.TraverseType.OUT_DEFINED_VERTEX.value(new String[]{UserClassDefinition.V.VUser.name()}), (String)traverseRole, (Integer)2);
        SelectWhereStep query = this.queryBuilder.selectFrom(traverseUser);
        return this.getFullUsers((Query)query).stream().findFirst();
    }

    private Collection<FullUserVertex> getFullUsers(Query query) {
        return (Collection)this.query(session -> {
            HashMap users = new HashMap();
            HashMap roles = new HashMap();
            HashMap userRoles = new HashMap();
            session.query(query.toString(), new Object[0]).forEachRemaining(res -> {
                if (res.isVertex()) {
                    Vertex vertex = this.findVertex(res);
                    if (UserClassDefinition.V.VUser.equals((Object)vertex.definition())) {
                        users.put(vertex.getORID(), (UserVertex)vertex);
                    } else if (UserClassDefinition.V.VUserRole.equals((Object)vertex.definition())) {
                        roles.put(vertex.getORID(), (UserRoleVertex)vertex);
                    }
                } else {
                    res.getEdge().ifPresent(edge -> {
                        if (this.checkEdgeType(edge, (EClassDefinition)UserClassDefinition.E.ERole)) {
                            userRoles.put(edge.getFrom().getIdentity(), edge.getTo().getIdentity());
                        }
                    });
                }
            });
            return userRoles.entrySet().stream().map(entry -> new FullUserVertex((UserVertex)users.get(entry.getKey()), (UserRoleVertex)roles.get(entry.getValue()))).collect(Collectors.toList());
        });
    }

    private Vertex<?> findVertex(OResult result) {
        Optional<OVertexDocument> vdoc = result.getVertex().map(OVertexDocument.class::cast);
        return vdoc.map(ODocument::getClassName).map(Functions.forwardThrowable(UserClassDefinition.V::valueOf)).map(v -> v.newInstance((OVertexDocument)vdoc.get())).map(Vertex.class::cast).orElseThrow(IllegalStateException::new);
    }
}

