/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.system.service;

import com.castsoftware.sca.scar.server.autoconfiguration.component.application.SCArApplication;
import com.castsoftware.sca.scar.server.preference.domain.ScannerPreferences;
import com.castsoftware.sca.scar.server.preference.repository.ScannerPreferencesRepository;
import com.castsoftware.sca.scar.server.system.dto.NavigableFileView;
import com.castsoftware.sca.scar.server.system.dto.NavigableFolderView;
import com.castsoftware.sca.scar.server.system.dto.NavigableItemView;
import com.castsoftware.sca.scar.server.system.dto.SystemInfoView;
import com.castsoftware.sca.scar.server.system.exception.CannotAccessPathException;
import com.castsoftware.sca.scar.server.system.exception.IncompatiblePathsException;
import com.castsoftware.sca.scar.server.system.exception.InvalidPathException;
import com.castsoftware.sca.scar.server.system.reader.BundleReader;
import com.castsoftware.sca.scar.server.system.resolver.PathResolver;
import com.castsoftware.sca.scar.server.util.Fields;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Opt;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SystemService.class);
    private final PathResolver pathResolver;
    private final BundleReader messageReader;
    private final JavaPropsMapper propsMapper;
    private final String version;
    private final ScannerPreferencesRepository scannerPreferencesRepository;

    public SystemService(PathResolver pathResolver, BundleReader messageReader, JavaPropsMapper propsMapper, @NonNull Supplier<String> version, ScannerPreferencesRepository scannerPreferencesRepository) {
        this.pathResolver = pathResolver;
        this.messageReader = messageReader;
        this.propsMapper = propsMapper;
        this.version = version.get();
        this.scannerPreferencesRepository = scannerPreferencesRepository;
    }

    public NavigableFolderView getSystemRootFolder() {
        return (NavigableFolderView)this.fromPath(this.pathResolver.getSystemRoot());
    }

    public NavigableFolderView getScannerRootFolder() {
        Path path = this.scannerPreferencesRepository.getPreferences().map(ScannerPreferences::getRootFolderId).map(rootId -> this.pathResolver.findPath(rootId, PathResolver.PathType.FOLDER)).orElse(this.pathResolver.getUserRoot());
        return (NavigableFolderView)this.fromPath(path);
    }

    public NavigableItemView getFileSystemItem(@NonNull String id) {
        return this.fromPath(this.pathResolver.findPath(Guards.notBlank((String)id), PathResolver.PathType.ALL));
    }

    public NavigableFolderView getItemParent(@NonNull String id) {
        return Opt.of((Object)this.pathResolver.findPath(Guards.notBlank((String)id), PathResolver.PathType.FOLDER)).map(Path::getParent).filter(p -> p.toFile().exists()).map(arg_0 -> this.fromPath(arg_0)).map(NavigableFolderView.class::cast).orElseThrow(() -> new InvalidPathException(id, PathResolver.PathType.FOLDER));
    }

    public List<NavigableItemView> getItemChildren(@NonNull String id, String ext) {
        List<NavigableItemView> list;
        block8: {
            Path path = this.pathResolver.findPath(id, PathResolver.PathType.FOLDER);
            Stream<Path> paths = Files.walk(path, 1, new FileVisitOption[0]);
            try {
                list = paths.filter(Predicates.negate(path::equals)).filter(SystemService.isDirectoryOrFileWithExtension((String)ext)).map(arg_0 -> this.fromPath(arg_0)).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CannotAccessPathException((Throwable)e);
                }
            }
            paths.close();
        }
        return list;
    }

    private static @NonNull Predicate<Path> isDirectoryOrFileWithExtension(String ext) {
        return path -> {
            File file = path.toFile();
            return file.isDirectory() || Strings.isBlank((String)ext) || "*".equals(ext) || file.getAbsolutePath().endsWith(ext);
        };
    }

    private @NonNull NavigableItemView fromPath(@NonNull Path path) {
        String pathAsString = path.toString();
        String encodedPath = Normalizes.encodeBase64URL((String)pathAsString);
        String fileName = path.toFile().getName();
        return path.toFile().isDirectory() ? new NavigableFolderView(encodedPath, fileName, pathAsString) : new NavigableFileView(encodedPath, fileName, pathAsString);
    }

    public NavigableFolderView getItemsBetween(@NonNull String from, @NonNull String to, String ext) {
        Path rootPath = this.pathResolver.findPath(Guards.notBlank((String)from), PathResolver.PathType.ALL);
        Path targetPath = this.pathResolver.findPath(Guards.notBlank((String)to), PathResolver.PathType.ALL);
        if (!targetPath.startsWith(rootPath)) {
            throw new IncompatiblePathsException();
        }
        return (NavigableFolderView)this.getItemsBetween(rootPath, targetPath, ext);
    }

    private @NonNull NavigableItemView getItemsBetween(@NonNull Path path, @NonNull Path targetPath, String ext) {
        NavigableItemView item = this.fromPath(path);
        if (item instanceof NavigableFolderView && !targetPath.equals(path) && targetPath.startsWith(path)) {
            try (Stream<Path> walk = Files.walk(path, 1, new FileVisitOption[0]);){
                walk.filter(Predicates.negate(path::equals)).filter(SystemService.isDirectoryOrFileWithExtension((String)ext)).forEach(p -> ((NavigableFolderView)item).addChild(this.getItemsBetween(p, targetPath, ext)));
            }
            catch (IOException e) {
                throw new CannotAccessPathException((Throwable)e);
            }
        }
        return item;
    }

    public Optional<SystemInfoView> getSystemInfo() {
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        Map<String, String> properties = runtimeBean.getSystemProperties();
        SystemInfoView.Application application = new SystemInfoView.Application();
        Fields.field((String)this.version, arg_0 -> ((SystemInfoView.Application)application).setVersion(arg_0));
        Fields.field((String)properties.get("user.dir"), arg_0 -> ((SystemInfoView.Application)application).setRootPath(arg_0));
        Fields.field((String)((Path)SCArApplication.defaultResourceLocation(Path::toAbsolutePath)).toString(), arg_0 -> ((SystemInfoView.Application)application).setHomePath(arg_0));
        SystemInfoView.System system = new SystemInfoView.System();
        Fields.field((String)properties.get("os.name"), arg_0 -> ((SystemInfoView.System)system).setOsName(arg_0));
        Fields.field((String)properties.get("os.version"), arg_0 -> ((SystemInfoView.System)system).setOsVersion(arg_0));
        Fields.field((String)properties.get("os.arch"), arg_0 -> ((SystemInfoView.System)system).setOsArchitecture(arg_0));
        try {
            Fields.field((String)InetAddress.getLocalHost().getHostAddress(), arg_0 -> ((SystemInfoView.System)system).setIpAddress(arg_0));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalMemorySize();
        Fields.field((Object)memorySize, arg_0 -> ((SystemInfoView.System)system).setTotalMemory(arg_0));
        SystemInfoView.Java java = new SystemInfoView.Java();
        Fields.field((String)properties.get("java.runtime.version"), arg_0 -> ((SystemInfoView.Java)java).setVersion(arg_0));
        Fields.field((String)properties.get("java.home"), arg_0 -> ((SystemInfoView.Java)java).setHomePath(arg_0));
        Fields.field((String)properties.get("java.vendor"), arg_0 -> ((SystemInfoView.Java)java).setVendor(arg_0));
        Fields.field((String)properties.get("java.vm.version"), arg_0 -> ((SystemInfoView.Java)java).setJvmVersion(arg_0));
        Fields.field((String)properties.get("java.vm.vendor"), arg_0 -> ((SystemInfoView.Java)java).setJvmVendor(arg_0));
        Runtime runtime = Runtime.getRuntime();
        Fields.field((Object)runtime.maxMemory(), arg_0 -> ((SystemInfoView.Java)java).setJvmMaxHeapSize(arg_0));
        Fields.field((Object)runtime.totalMemory(), arg_0 -> ((SystemInfoView.Java)java).setJvmCurrentHeapSize(arg_0));
        Fields.field((Object)(runtime.maxMemory() - runtime.freeMemory()), arg_0 -> ((SystemInfoView.Java)java).setJvmUsedMemory(arg_0));
        Fields.field((Object)runtime.freeMemory(), arg_0 -> ((SystemInfoView.Java)java).setJvmFreeMemory(arg_0));
        return Optional.of(new SystemInfoView(application, system, java));
    }

    public JsonNode getBundleMessages(String locale) {
        Locale resolvedLocale = Opt.ofBlankString((String)locale).map(l -> l.replace("_", "-")).map(Locale::forLanguageTag).orElseGet(Locale::getDefault);
        try {
            Properties properties = this.messageReader.getLocalizedMessages(resolvedLocale);
            return (JsonNode)this.propsMapper.readPropertiesAs(properties, JsonNode.class);
        }
        catch (IOException e) {
            Optional.of(LOGGER).filter(Logger::isDebugEnabled).ifPresent(l -> l.debug("fail to read messages", (Throwable)e));
            throw new IllegalArgumentException("fail to read messages", e);
        }
    }
}

