/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.system.resolver;

import com.castsoftware.sca.scar.server.system.exception.InvalidPathException;
import com.castsoftware.sca.scar.server.system.resolver.PathResolver;
import com.castsoftware.sca.scar.server.util.Normalizes;
import com.castsoftware.sca.util.java.Opt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PathResolver {
    private final Path userRoot;

    public PathResolver(@NonNull Path userRoot) {
        this.userRoot = userRoot;
        Opt.ofNullable((Object)userRoot.getRoot()).orElseThrow(() -> new NoSuchElementException("Root path required"));
    }

    public @NonNull Path getSystemRoot() {
        return this.userRoot.getRoot();
    }

    public Path findPath(String id, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PathResolver.PathType type) {
        return Opt.ofBlankString((String)id).map(Normalizes::decodeBase64URL).map(x$0 -> Paths.get(x$0, new String[0])).filter(this.isValidPath(type)).orElseThrow(() -> new InvalidPathException(id, type));
    }

    private @NonNull Predicate<Path> isValidPath(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull PathResolver.PathType type) {
        return path -> {
            File file = path.toFile();
            return file.exists() && (type.equals((Object)PathType.ALL) || type.equals((Object)PathType.FOLDER) && file.isDirectory() || type.equals((Object)PathType.FILE) && file.isFile());
        };
    }

    @Generated
    public Path getUserRoot() {
        return this.userRoot;
    }
}

