/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.system.reader;

import com.castsoftware.sca.util.java.Opt;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;

public class BundleReader {
    public static final String DEFAULT_BASENAME = "i18n/messages";
    private final String basename;

    public BundleReader(String basename) {
        this.basename = basename;
        Locale.setDefault(Locale.ENGLISH);
    }

    public Properties getLocalizedMessages(Locale locale) {
        Properties props = new Properties();
        ResourceBundle bundle = ResourceBundle.getBundle(this.basename, Optional.ofNullable(locale).orElseThrow(IllegalArgumentException::new));
        bundle.keySet().forEach(key -> props.setProperty((String)key, bundle.getString((String)key)));
        return props;
    }

    public String getLocalizedMessage(String key, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.basename);
        return Opt.ofBlankString((String)key).filter(bundle::containsKey).map(bundle::getString).map(s -> String.format(s, args)).orElseGet(() -> String.format("__%s__", key));
    }
}

