/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.system.ioc;

import com.castsoftware.sca.scar.server.preference.repository.ScannerPreferencesRepository;
import com.castsoftware.sca.scar.server.system.reader.BundleReader;
import com.castsoftware.sca.scar.server.system.resolver.PathResolver;
import com.castsoftware.sca.scar.server.system.service.SystemService;
import com.castsoftware.sca.util.java.Functions;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Configuration
public class SystemIOC {
    private static final String UNKNOWN_VERSION = "Unknown";

    @Bean
    public PathResolver pathResolver() {
        return new PathResolver(Paths.get(System.getProperty("user.home"), new String[0]));
    }

    @Bean
    public BundleReader messageReader() {
        return new BundleReader("i18n/messages");
    }

    @Bean
    public Supplier<String> serverVersionSupplier() {
        return () -> Optional.of("git.properties").map(Functions.evictThrowable(ClassPathResource::new)).map(Functions.evictThrowable(PropertiesLoaderUtils::loadProperties)).map(props -> String.format("%s.%s", StringUtils.defaultIfBlank((CharSequence)props.getProperty("git.build.version"), (CharSequence)UNKNOWN_VERSION), StringUtils.defaultIfBlank((CharSequence)props.getProperty("git.commit.id.abbrev"), (CharSequence)UNKNOWN_VERSION))).orElse(UNKNOWN_VERSION);
    }

    @Bean
    public SystemService systemService(PathResolver resolver, BundleReader messageReader, Supplier<String> serverVersionSupplier, ScannerPreferencesRepository scannerPreferencesRepository) {
        return new SystemService(resolver, messageReader, (JavaPropsMapper)JavaPropsMapper.builder().build(), serverVersionSupplier, scannerPreferencesRepository);
    }
}

