/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.security.service;

import com.castsoftware.sca.scar.server.security.core.UserDetailsImpl;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.domain.FullUserVertex;
import com.castsoftware.sca.scar.server.user.domain.UserPermission;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements UserDetailsService {
    private final UserDao userDao;

    public UserDetailsServiceImpl(UserDao userDao) {
        this.userDao = userDao;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        FullUserVertex user = (FullUserVertex)this.userDao.findFullUserByEmail(username).orElseThrow(() -> new UsernameNotFoundException("User not found with email: '" + username + "'"));
        return new UserDetailsImpl(user, this.getAuthorities(user.getUserRole()));
    }

    private @NonNull Collection<? extends GrantedAuthority> getAuthorities(@NonNull UserRoleVertex role) {
        ArrayList<Object> privileges = new ArrayList<Object>();
        privileges.add("ROLE_" + role.getId());
        privileges.addAll(role.getPermissions().stream().map(UserPermission::valueOfName).map(Enum::name).map(name -> "ROLE_" + name).toList());
        return this.getGrantedAuthorities(privileges);
    }

    private @NonNull Collection<? extends GrantedAuthority> getGrantedAuthorities(@NonNull List<String> privileges) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        for (String privilege : privileges) {
            authorities.add(new SimpleGrantedAuthority(privilege));
        }
        return authorities;
    }
}

