/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.security.service;

import com.castsoftware.sca.scar.server.sam.requester.SamAuthenticationRequester;
import com.castsoftware.sca.scar.server.security.exception.BadCredentialsException;
import com.castsoftware.sca.scar.server.security.model.request.LoginRequest;
import com.castsoftware.sca.scar.server.security.service.AbstractAuthService;
import com.castsoftware.sca.scar.server.user.handler.OwnerWriter;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;

public class AuthServiceImpl
extends AbstractAuthService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(AuthServiceImpl.class);
    private final AuthenticationManager authenticationManager;
    private final CsrfTokenRepository csrfTokenRepository;
    private final SecurityContextRepository securityContextRepository;
    private final OwnerWriter ownerWriter;
    private final SamAuthenticationRequester samAuthenticationRequester;

    public void login(LoginRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        try {
            this.authenticate(request, servletRequest, servletResponse);
        }
        catch (BadCredentialsException | AuthenticationException e) {
            LOGGER.info("Authentication failed for user {}. Attempting transparent recovery via SAM.", (Object)request.getEmail());
            try {
                this.samAuthenticationRequester.signInWithPassword(request.getEmail(), request.getPassword()).block();
                LOGGER.info("SAM authentication successful for user {}. Resetting owner account.", (Object)request.getEmail());
                this.ownerWriter.resetOwnerAccount(request.getEmail(), request.getPassword());
                this.authenticate(request, servletRequest, servletResponse);
                LOGGER.info("Transparent recovery successful for user {}.", (Object)request.getEmail());
            }
            catch (Exception secondary) {
                LOGGER.warn("Transparent recovery failed for user {}: {}", (Object)request.getEmail(), (Object)secondary.getMessage());
                throw e;
            }
        }
    }

    private void authenticate(LoginRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)request.getEmail(), (Object)request.getPassword()));
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication(authentication);
        this.securityContextRepository.saveContext(context, servletRequest, servletResponse);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        this.csrfTokenRepository.saveToken(null, request, response);
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication(null);
        SecurityContextHolder.clearContext();
    }

    public void resetOwner(String email, String password) {
        this.ownerWriter.resetOwnerAccount(email, password);
    }

    @Generated
    public AuthServiceImpl(AuthenticationManager authenticationManager, CsrfTokenRepository csrfTokenRepository, SecurityContextRepository securityContextRepository, OwnerWriter ownerWriter, SamAuthenticationRequester samAuthenticationRequester) {
        this.authenticationManager = authenticationManager;
        this.csrfTokenRepository = csrfTokenRepository;
        this.securityContextRepository = securityContextRepository;
        this.ownerWriter = ownerWriter;
        this.samAuthenticationRequester = samAuthenticationRequester;
    }
}

