/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.security.ioc;

import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.SsoProperties;
import com.castsoftware.sca.scar.server.security.components.Saml2UserDetailsAuthenticationManager;
import com.castsoftware.sca.scar.server.security.service.AbstractAuthService;
import com.castsoftware.sca.scar.server.security.service.AuthService;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import jakarta.servlet.Filter;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.saml2.provider.service.metadata.OpenSaml4MetadataResolver;
import org.springframework.security.saml2.provider.service.metadata.Saml2MetadataResolver;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2MetadataFilter;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2WebSsoAuthenticationFilter;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(securedEnabled=true, jsr250Enabled=true)
@ConditionalOnProperty(prefix="sca.scar", name={"connectionType"}, havingValue="SAML_USER")
public class SamlUserSecurityConfig {
    private static final String[] PUBLIC_PATTERNS = new String[]{"/*", "/vendor/**", "/resources/sse", "/resources/system/bundles/**", "/resources/system/locales/**", "/resources/application/**", "/resources/users/whoami", "/login/**"};

    @Bean
    public Saml2UserDetailsAuthenticationManager authenticationManager(UserDao userDao, UserRoleDao userRoleDao) {
        return new Saml2UserDetailsAuthenticationManager(userDao, userRoleDao);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, AuthenticationManager authenticationManager, RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) throws Exception {
        DefaultRelyingPartyRegistrationResolver relyingPartyRegistrationResolver = new DefaultRelyingPartyRegistrationResolver(relyingPartyRegistrationRepository);
        Saml2MetadataFilter filter = new Saml2MetadataFilter((RelyingPartyRegistrationResolver)relyingPartyRegistrationResolver, (Saml2MetadataResolver)new OpenSaml4MetadataResolver());
        return (SecurityFilterChain)http.csrf(AbstractHttpConfigurer::disable).saml2Login(login -> login.authenticationManager(authenticationManager)).addFilterBefore((Filter)filter, Saml2WebSsoAuthenticationFilter.class).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(PUBLIC_PATTERNS)).permitAll().anyRequest()).authenticated()).build();
    }

    @Bean
    public RelyingPartyRegistration relyingPartyRegistration(ScarServerProperties config) {
        return Optional.ofNullable(config).map(ScarServerProperties::getSaml).map(saml -> RelyingPartyRegistrations.fromMetadataLocation((String)saml.getMetadataLocation()).registrationId(saml.getRegistrationId()).build()).orElseThrow(() -> new IllegalStateException("Missing SAML configuration"));
    }

    @Bean
    public RelyingPartyRegistrationRepository relyingPartyRegistrationRepository(RelyingPartyRegistration relyingPartyRegistration) {
        return new InMemoryRelyingPartyRegistrationRepository(new RelyingPartyRegistration[]{relyingPartyRegistration});
    }

    @Bean
    public SsoProperties ssoConfiguration(ScarServerProperties config, RelyingPartyRegistration registration) {
        SsoProperties sso = new SsoProperties();
        sso.setRegistrationId(registration.getRegistrationId());
        sso.setMetadataUrl(config.getSaml().getMetadataLocation());
        sso.setSingleSignOnUrl(registration.getAssertingPartyMetadata().getSingleSignOnServiceLocation());
        return sso;
    }

    @Bean
    public AuthService authService() {
        return new AbstractAuthService();
    }
}

