/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.security.ioc;

import com.castsoftware.sca.scar.server.application.configuration.SsoProperties;
import com.castsoftware.sca.scar.server.sam.requester.SamAuthenticationRequester;
import com.castsoftware.sca.scar.server.security.service.AuthService;
import com.castsoftware.sca.scar.server.security.service.AuthServiceImpl;
import com.castsoftware.sca.scar.server.security.service.UserDetailsServiceImpl;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.handler.OwnerWriter;
import java.util.Collections;
import lombok.Generated;
import org.apache.tomcat.util.http.CookieProcessor;
import org.apache.tomcat.util.http.Rfc6265CookieProcessor;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity(securedEnabled=true, jsr250Enabled=true)
@ConditionalOnProperty(prefix="sca.scar", name={"connectionType"}, havingValue="MULTI_USER")
public class MultiUserSecurityConfig {
    private static final String[] PUBLIC_PATTERNS = new String[]{"/*", "/vendor/**", "/resources/sse", "/resources/system/bundles/**", "/resources/system/locales/**", "/resources/application/**", "/resources/auth/login", "/resources/auth/reset", "/resources/users/whoami"};

    @Bean
    public UserDetailsServiceImpl userDetailsService(UserDao userDao) {
        return new UserDetailsServiceImpl(userDao);
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http, CsrfTokenRepository csrfTokenRepository, SecurityContextRepository securityContextRepository) throws Exception {
        CsrfTokenRequestAttributeHandler requestHandler = new CsrfTokenRequestAttributeHandler();
        requestHandler.setCsrfRequestAttributeName("_csrf");
        return (SecurityFilterChain)http.cors(cors -> cors.configurationSource(this.corsConfig())).csrf(csrf -> csrf.ignoringRequestMatchers(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher("/resources/auth/login"), PathPatternRequestMatcher.withDefaults().matcher("/resources/auth/reset")}).csrfTokenRepository(csrfTokenRepository).csrfTokenRequestHandler((CsrfTokenRequestHandler)requestHandler)).securityContext(securityContext -> securityContext.securityContextRepository(securityContextRepository)).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(PUBLIC_PATTERNS)).permitAll().anyRequest()).authenticated()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).sessionFixation().changeSessionId().maximumSessions(1)).exceptionHandling(exception -> exception.authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED))).logout(AbstractHttpConfigurer::disable).headers(headers -> headers.xssProtection(Customizer.withDefaults())).build();
    }

    private @NonNull CorsConfigurationSource corsConfig() {
        return request -> {
            CorsConfiguration config = new CorsConfiguration();
            config.setAllowedOrigins(Collections.singletonList("http://localhost:9000"));
            config.setAllowedMethods(Collections.singletonList("*"));
            config.setAllowCredentials(Boolean.valueOf(true));
            config.setAllowedHeaders(Collections.singletonList("*"));
            config.setExposedHeaders(Collections.singletonList("Authorization"));
            config.setMaxAge(Long.valueOf(3600L));
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            source.registerCorsConfiguration("/**", config);
            return config;
        };
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration configuration) throws Exception {
        return configuration.getAuthenticationManager();
    }

    @Bean
    public SecurityContextRepository securityContextRepository() {
        return new DelegatingSecurityContextRepository(new SecurityContextRepository[]{new HttpSessionSecurityContextRepository(), new RequestAttributeSecurityContextRepository()});
    }

    @Bean
    public AuthService authService(AuthenticationManager authenticationManager, CsrfTokenRepository csrfTokenRepository, SecurityContextRepository securityContextRepository, OwnerWriter ownerWriter, SamAuthenticationRequester samAuthenticationRequester) {
        return new AuthServiceImpl(authenticationManager, csrfTokenRepository, securityContextRepository, ownerWriter, samAuthenticationRequester);
    }

    @Bean
    public SsoProperties ssoConfiguration() {
        return new SsoProperties();
    }

    @Bean
    public TomcatContextCustomizer sameSiteCookiesConfig() {
        return context -> {
            Rfc6265CookieProcessor cookieProcessor = new Rfc6265CookieProcessor();
            cookieProcessor.setSameSiteCookies(SameSiteCookies.STRICT.getValue());
            context.setCookieProcessor((CookieProcessor)cookieProcessor);
        };
    }

    @Generated
    public MultiUserSecurityConfig() {
    }
}

