/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.security.components;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.security.core.Saml2WithUserDetailsAuthentication;
import com.castsoftware.sca.scar.server.security.core.UserDetailsImpl;
import com.castsoftware.sca.scar.server.security.utils.AuthorityUtils;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.scar.server.user.dao.UserRoleDao;
import com.castsoftware.sca.scar.server.user.domain.FullUserVertex;
import com.castsoftware.sca.scar.server.user.domain.UserRoleType;
import com.castsoftware.sca.scar.server.user.domain.UserRoleVertex;
import com.castsoftware.sca.scar.server.user.domain.UserVertex;
import com.castsoftware.sca.scar.server.user.structure.UserClassDefinition;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml5AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;

public class Saml2UserDetailsAuthenticationManager
implements AuthenticationManager {
    private final UserDao userDao;
    private final UserRoleDao userRoleDao;
    private final OpenSaml5AuthenticationProvider openSamlAuthProvider = new OpenSaml5AuthenticationProvider();

    public Saml2UserDetailsAuthenticationManager(UserDao userDao, UserRoleDao userRoleDao) {
        this.userDao = userDao;
        this.userRoleDao = userRoleDao;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Saml2Authentication saml2AuthenticationResult = (Saml2Authentication)this.openSamlAuthProvider.authenticate(authentication);
        Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)saml2AuthenticationResult.getPrincipal();
        String email = (String)principal.getFirstAttribute("http://schemas.castsoftware.com/ws/2023/06/scar/identity/claims/email");
        UserDetails userDetails = (UserDetails)this.userDao.findFullUserByEmail(email).map(user -> new UserDetailsImpl(user, AuthorityUtils.getUserAuthorities((UserRoleVertex)user.getUserRole()))).orElseGet(() -> {
            FullUserVertex newUser = this.generateDefaultUser(email);
            return new UserDetailsImpl(newUser, AuthorityUtils.getUserAuthorities((UserRoleVertex)newUser.getUserRole()));
        });
        return new Saml2WithUserDetailsAuthentication(saml2AuthenticationResult, userDetails);
    }

    private FullUserVertex generateDefaultUser(String email) {
        UserRoleVertex userRole = (UserRoleVertex)this.userRoleDao.findByType(UserRoleType.DEFAULT).stream().findFirst().orElseThrow(() -> new InternalAuthenticationServiceException("Unable to retrieve default user role"));
        UserVertex user = new UserVertex();
        user.setEmail(email);
        user.setEnabled(true);
        user.setOwner(false);
        return (FullUserVertex)this.userDao.getWithTransaction(session -> {
            UserVertex saved = (UserVertex)this.userDao.save((Vertex)user, session);
            this.userDao.link((Vertex)saved, (Vertex)userRole, (EClassDefinition)UserClassDefinition.E.ERole, session);
            return new FullUserVertex(user, userRole);
        });
    }
}

