/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.utils;

import com.castsoftware.sca.scar.server.application.configuration.ServiceClientProperties;
import com.castsoftware.sca.scar.server.sam.exception.CannotConnectToSamException;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.transport.ProxyProvider;
import reactor.util.retry.Retry;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebClientUtils {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(WebClientUtils.class);
    public static final String OPERATION_NAME = "operationName";
    private static final List<Class<? extends Throwable>> NETWORK_ERROR_TYPES = Arrays.asList(UnknownHostException.class, NoRouteToHostException.class, ConnectException.class, SocketException.class, SocketTimeoutException.class, SSLException.class, ReadTimeoutException.class, TimeoutException.class);

    public static @NonNull String baseUrl(@NonNull ServiceClientProperties<?> config) {
        return String.format("%s://%s%s", config.isSecured() ? "https" : "http", config.getHost(), config.getPort() > 0 ? ":" + config.getPort() : "");
    }

    public static @NonNull ClientHttpConnector clientConnector(@NonNull ServiceClientProperties<?> configuration, ConnectionProvider connectionProvider) {
        HttpClient httpClient = connectionProvider != null ? WebClientUtils.configureHttpClient((HttpClient)HttpClient.create((ConnectionProvider)connectionProvider), configuration) : WebClientUtils.configureHttpClient((HttpClient)HttpClient.create(), configuration);
        return new ReactorClientHttpConnector(httpClient);
    }

    private static @NonNull HttpClient configureHttpClient(@NonNull HttpClient httpClient, @NonNull ServiceClientProperties<?> configuration) {
        Predicate<Integer> isValidTimeout = timeout -> timeout > 1;
        HttpClient httpClientWithOptions = Optional.ofNullable(configuration.getConnectionTimeout()).filter(isValidTimeout).map(timeout -> (HttpClient)((HttpClient)((HttpClient)httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, timeout)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).orElse((HttpClient)((HttpClient)httpClient.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true));
        HttpClient httpClientWithTimeouts = Optional.ofNullable(configuration.getReadTimeout()).filter(isValidTimeout).map(timeout -> (HttpClient)httpClientWithOptions.doOnConnected(connection -> connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)timeout.intValue(), TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(10L, TimeUnit.SECONDS)))).orElse(httpClientWithOptions);
        HttpClient httpClientWithProxy = Optional.of(configuration).map(ServiceClientProperties::getProxy).filter(proxy -> StringUtils.isNotBlank((CharSequence)proxy.getHost())).map(proxyConfig -> (HttpClient)httpClientWithTimeouts.proxy(proxySpec -> {
            ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxyConfig.getHost());
            Optional.of(configuration).map(ServiceClientProperties::getProxy).map(ServiceClientProperties.ProxyConfiguration::getPort).filter(p -> p > 0).ifPresent(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
        })).orElse(httpClientWithTimeouts);
        return httpClientWithProxy.responseTimeout(Duration.ofSeconds(30L));
    }

    public static boolean isNetworkIssue(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (NETWORK_ERROR_TYPES.contains(throwable.getClass())) {
            return true;
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            return WebClientUtils.isNetworkIssue((Throwable)cause);
        }
        return throwable instanceof WebClientResponseException.ServiceUnavailable;
    }

    public static boolean isClientError(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof WebClientResponseException) {
            return ((WebClientResponseException)throwable).getStatusCode().is4xxClientError();
        }
        return false;
    }

    public static @NonNull Retry networkRetryWithBackoff(@NonNull String operationName) {
        return Retry.backoff((long)3L, (Duration)Duration.ofMillis(500L)).maxBackoff(Duration.ofSeconds(5L)).filter(WebClientUtils::isNetworkIssue).doBeforeRetry(signal -> LOGGER.warn("[SAM {}] Network error occurred, retrying (attempt {}/3): {}", new Object[]{operationName, signal.totalRetries() + 1L, signal.failure().getMessage()})).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> new CannotConnectToSamException(retrySignal.failure()));
    }

    @Generated
    private WebClientUtils() {
    }
}

