/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.service;

import com.castsoftware.sca.scar.server.message.Message;
import com.castsoftware.sca.scar.server.message.MessageService;
import com.castsoftware.sca.scar.server.message.MessageSource;
import com.castsoftware.sca.scar.server.message.MessageType;
import com.castsoftware.sca.scar.server.sam.configuration.SamClientsProperties;
import com.castsoftware.sca.scar.server.sam.model.response.SamLatestVersionResponse;
import com.castsoftware.sca.scar.server.sam.requester.SamInfoRequester;
import com.castsoftware.sca.scar.server.util.VersionUtils;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class SamVersionCheckService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SamVersionCheckService.class);
    private final SamInfoRequester samInfoRequester;
    private final MessageService messageService;
    private final SamClientsProperties.SamVersionCheckProperties properties;
    private final String currentVersion;
    private final Scheduler scheduler;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private Disposable scheduledTask;

    public SamVersionCheckService(@NonNull SamInfoRequester samInfoRequester, @NonNull MessageService messageService, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull SamClientsProperties.SamVersionCheckProperties properties, @NonNull String currentVersion, @Nullable Scheduler scheduler) {
        this.samInfoRequester = samInfoRequester;
        this.messageService = messageService;
        this.properties = properties;
        this.currentVersion = this.normalizeVersion(currentVersion);
        this.scheduler = Objects.requireNonNullElse(scheduler, Schedulers.parallel());
    }

    public void startPolling() {
        if (!this.properties.isEnabled()) {
            LOGGER.info("[VERSION-CHECK] Version checking is disabled");
            return;
        }
        if (!this.isRunning.compareAndSet(false, true)) {
            LOGGER.warn("[VERSION-CHECK] Version checking is already running!");
            return;
        }
        LOGGER.info("[VERSION-CHECK] Starting version check (current: {}, interval: {} hours)", (Object)this.currentVersion, (Object)this.properties.getPollingIntervalHours());
        this.scheduledTask = Flux.interval((Duration)Duration.ZERO, (Duration)Duration.ofHours(this.properties.getPollingIntervalHours()), (Scheduler)this.scheduler).concatMap(tick -> this.checkForNewVersion()).subscribe(versionInfo -> {
            if (versionInfo != null) {
                LOGGER.info("[VERSION-CHECK] New version available: {}", versionInfo);
            } else {
                LOGGER.debug("[VERSION-CHECK] Running latest version");
            }
        }, error -> LOGGER.warn("[VERSION-CHECK] Unexpected error in version check scheduler", error));
    }

    @PreDestroy
    public void stopPolling() {
        if (this.scheduledTask != null && !this.scheduledTask.isDisposed()) {
            this.scheduledTask.dispose();
            this.isRunning.set(false);
            LOGGER.info("[VERSION-CHECK] Version checking stopped");
        }
    }

    public Mono<String> checkForNewVersion() {
        LOGGER.debug("[VERSION-CHECK] Checking for new version (current: {})", (Object)this.currentVersion);
        this.removeExistingVersionNotifications();
        return this.samInfoRequester.getLatestVersion().flatMap(response -> {
            String latestVersion = response.version();
            if (latestVersion == null || latestVersion.isBlank()) {
                LOGGER.debug("[VERSION-CHECK] No version information returned from SAM");
                return Mono.empty();
            }
            String normalizedLatestVersion = this.normalizeVersion(latestVersion);
            try {
                if (VersionUtils.isNewerVersion((String)normalizedLatestVersion, (String)this.currentVersion)) {
                    LOGGER.info("[VERSION-CHECK] New version available: {} (current: {})", (Object)latestVersion, (Object)this.currentVersion);
                    this.createVersionNotification(response);
                    return Mono.just((Object)latestVersion);
                }
                LOGGER.debug("[VERSION-CHECK] Current version {} is up to date", (Object)this.currentVersion);
                return Mono.empty();
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("[VERSION-CHECK] Invalid version format - current: {}, latest: {}", new Object[]{this.currentVersion, latestVersion, e});
                return Mono.empty();
            }
        }).onErrorResume(error -> {
            LOGGER.error("[VERSION-CHECK] Failed to check for new version", error);
            return Mono.empty();
        });
    }

    private void removeExistingVersionNotifications() {
        LOGGER.debug("[VERSION-CHECK] Cleaning up old version notifications");
        this.messageService.deleteMessagesByType(MessageType.NEW_MANAGER_VERSION);
    }

    private void createVersionNotification(@NonNull SamLatestVersionResponse versionInfo) {
        Message message = new Message();
        message.setMessage(String.format("A new version of SBOM Manager is available: %s", versionInfo.version()));
        message.setType(MessageType.NEW_MANAGER_VERSION);
        message.setSource(MessageSource.SAM);
        message.addAction(versionInfo.downloadUrl(), "Download");
        this.messageService.createMessage(message);
        LOGGER.info("[VERSION-CHECK] Created notification for version {}", (Object)versionInfo.version());
    }

    private @NonNull String normalizeVersion(@NonNull String version) {
        int dashIndex = version.indexOf(45);
        int plusIndex = version.indexOf(43);
        int endIndex = version.length();
        if (dashIndex > 0) {
            endIndex = dashIndex;
        }
        if (plusIndex > 0 && plusIndex < endIndex) {
            endIndex = plusIndex;
        }
        return version.substring(0, endIndex);
    }
}

