/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.sam.configuration.SamAccountCredentials;
import com.castsoftware.sca.scar.server.sam.domain.SBomConfiguration;
import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamAuthTokens;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkStatus;
import com.castsoftware.sca.scar.server.sam.exception.CannotConnectToSamException;
import com.castsoftware.sca.scar.server.sam.exception.InvalidSamAccountException;
import com.castsoftware.sca.scar.server.sam.exception.SamAuthenticationFailedException;
import com.castsoftware.sca.scar.server.sam.exception.UnexpectedSamException;
import com.castsoftware.sca.scar.server.sam.handler.SamLinkContext;
import com.castsoftware.sca.scar.server.sam.handler.SamUsageStatsUpdater;
import com.castsoftware.sca.scar.server.sam.model.request.SamPasswordResetRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamSignUpRequest;
import com.castsoftware.sca.scar.server.sam.model.response.SamAccountDetailsResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamAuthTokensResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamSbomIdentityResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamSecretKeyResponse;
import com.castsoftware.sca.scar.server.sam.requester.SamAccountRequester;
import com.castsoftware.sca.scar.server.sam.requester.SamAuthenticationRequester;
import com.castsoftware.sca.scar.server.sam.requester.SamPublicRequester;
import com.castsoftware.sca.scar.server.sam.utils.MonoCacheUtils;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
public class SamAccountService {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SamAccountService.class);
    private final ScarServerProperties scarServerProperties;
    private final SamAuthenticationRequester authenticationRequester;
    private final SamAccountRequester accountsRequester;
    private final SamPublicRequester publicRequester;
    private final SamUsageStatsUpdater usageStatsFetcher;
    private final AtomicReference<Mono<String>> ongoingTokenRefresh = new AtomicReference();

    public SamAccountService(ScarServerProperties scarServerProperties, SamAuthenticationRequester authenticationRequester, SamAccountRequester accountsRequester, SamPublicRequester publicRequester, SamUsageStatsUpdater usageStatsFetcher) {
        this.scarServerProperties = scarServerProperties;
        this.authenticationRequester = authenticationRequester;
        this.accountsRequester = accountsRequester;
        this.publicRequester = publicRequester;
        this.usageStatsFetcher = usageStatsFetcher;
        Optional.ofNullable(scarServerProperties).map(ScarServerProperties::getSamUser).map(SamAccountCredentials::getSecretKey).ifPresent(SamLinkContext::updateSecretKey);
    }

    public SamAccountCredentials linkNewAccount(SamSignUpRequest signUpRequest) {
        return (SamAccountCredentials)this.signUp(signUpRequest).flatMap(arg_0 -> this.retrieveCredentials(arg_0)).block();
    }

    public SamAccountCredentials linkExistingSamAccount(String login, String password) {
        return (SamAccountCredentials)this.signInWithPassword(login, password).flatMap(arg_0 -> this.retrieveCredentials(arg_0)).block();
    }

    private @NonNull Mono<SamAccountCredentials> retrieveCredentials(String accountId) {
        return this.accountsRequester.getAccountDetails(accountId).doOnNext(details -> {
            SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.RESTRICTED);
            SamLinkContext.updateSecretKey((String)details.getSecretKey());
        }).zipWith(this.accountsRequester.getAccountSBomIdentity(accountId), (arg_0, arg_1) -> this.combineAccountDetails(arg_0, arg_1)).onErrorMap(Exception.class, UnexpectedSamException::new).doOnNext(arg_0 -> this.verifySamAccount(arg_0)).doOnNext(samAccount -> {
            SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.CONNECTED);
            SamLinkContext.updateSamAccount((SamAccount)samAccount);
        }).map(_samAccount -> this.extractConfiguration());
    }

    private void verifySamAccount(SamAccount samAccount) {
        Optional.of(samAccount).filter(SamAccount::isEnabled).orElseThrow(InvalidSamAccountException::disabled);
        Optional.of(samAccount).map(SamAccount::getSbomConfiguration).map(SBomConfiguration::getExpiryDate).filter(date -> new Date().before((Date)date)).orElseThrow(InvalidSamAccountException::expired);
    }

    public void establishSamConnection() {
        if (!this.isSamLinkConfigValid()) {
            SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.INVALID_CONFIG);
            LOGGER.error("[SAM Access] Invalid local SAM configuration !");
        }
        this.getSecretKey().flatMap(arg_0 -> this.signInWithSecret(arg_0)).flatMap(arg_0 -> ((SamAccountRequester)this.accountsRequester).getAccountDetails(arg_0)).doOnNext(details -> {
            SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.RESTRICTED);
            SamLinkContext.updateSecretKey((String)details.getSecretKey());
        }).flatMap(details -> this.accountsRequester.getAccountSBomIdentity(details.getAccountId()).onErrorResume(e -> {
            if (e instanceof WebClientResponseException.NotFound) {
                LOGGER.error("[SAM Access] SBOM identity not found for account '{}'", (Object)details.getAccountId());
                return Mono.empty();
            }
            return Mono.error((Throwable)e);
        }).map(sbom -> this.combineAccountDetails(details, sbom)).defaultIfEmpty((Object)this.combineAccountDetails(details, null))).doOnNext(combinedDetails -> {
            SamLinkContext.updateSamAccount((SamAccount)combinedDetails);
            if (combinedDetails.getSbomConfiguration() != null) {
                SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.CONNECTED);
            }
        }).onErrorResume(e -> Mono.empty()).block();
    }

    private @NonNull Mono<String> getSecretKey() {
        return Mono.justOrEmpty((Object)this.scarServerProperties.getSamUser()).map(SamAccountCredentials::getSecretKey);
    }

    private boolean isSamLinkConfigValid() {
        return Optional.of(this.scarServerProperties).map(ScarServerProperties::getSamUser).filter(credentials -> StringUtils.isNotBlank((CharSequence)credentials.getId()) && StringUtils.isNotBlank((CharSequence)credentials.getEmail()) && StringUtils.isNotBlank((CharSequence)credentials.getSecretKey())).filter(credentials -> {
            try {
                JWT.decode((String)credentials.getSecretKey());
            }
            catch (JWTDecodeException e) {
                return false;
            }
            return true;
        }).isPresent();
    }

    private @NonNull Mono<String> signUp(SamSignUpRequest signUpRequest) {
        return this.authenticationRequester.signUp(signUpRequest).map(SamSecretKeyResponse::getSecretKey).doOnNext(SamLinkContext::updateSecretKey).flatMap(arg_0 -> ((SamAuthenticationRequester)this.authenticationRequester).signInWithSecret(arg_0)).doOnNext(tokens -> SamLinkContext.updateAuthTokens((SamAuthTokens)SamAccountService.mapTokens((SamAuthTokensResponse)tokens))).map(SamAuthTokensResponse::getAccountId);
    }

    private @NonNull Mono<String> signInWithPassword(String login, String password) {
        return this.handleSignIn(this.authenticationRequester.signInWithPassword(login, password));
    }

    private @NonNull Mono<String> signInWithSecret(String secretKey) {
        return this.handleSignIn(this.authenticationRequester.signInWithSecret(secretKey));
    }

    private @NonNull Mono<String> handleSignIn(@NonNull Mono<SamAuthTokensResponse> resp) {
        return resp.doOnError(CannotConnectToSamException.class, arg_0 -> this.cannotConnect(arg_0)).doOnError(SamAuthenticationFailedException.class, arg_0 -> this.authenticationFailed(arg_0)).doOnError(UnexpectedSamException.class, arg_0 -> this.unexpectedError(arg_0)).doOnNext(tokens -> SamLinkContext.updateAuthTokens((SamAuthTokens)SamAccountService.mapTokens((SamAuthTokensResponse)tokens))).map(SamAuthTokensResponse::getAccountId);
    }

    private void cannotConnect(Throwable throwable) {
        SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.CANNOT_CONNECT);
        LOGGER.error("[SAM Access] Unable to connect to SAM !", throwable);
    }

    private void authenticationFailed(Throwable throwable) {
        SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.INVALID_CREDENTIALS);
        LOGGER.error("[SAM Access] Authentication failed !", throwable);
    }

    private void unexpectedError(Throwable throwable) {
        SamLinkContext.updateLinkStatus((SamLinkStatus)SamLinkStatus.UNEXPECTED_ERROR);
        LOGGER.error("[SAM Access] Unexpected error whilst signing-in !", throwable);
    }

    private @NonNull SamAccountCredentials extractConfiguration() {
        SamLinkState linkState = SamLinkContext.get();
        return new SamAccountCredentials(linkState.getSamAccount().getId(), linkState.getSamAccount().getEmail(), linkState.getSecretKey());
    }

    private static @NonNull SamAuthTokens mapTokens(@NonNull SamAuthTokensResponse resp) {
        return new SamAuthTokens(resp.getAccessToken(), resp.getRenewalToken());
    }

    private SamAccount combineAccountDetails(@NonNull SamAccountDetailsResponse details, SamSbomIdentityResponse identity) {
        SBomConfiguration sBomConfig = Optional.ofNullable(identity).map(id -> SBomConfiguration.builder().profileName(id.getProfile()).expiryDate(id.getExpiryDate()).renewalDate(id.getRenewalDate()).maxSBoms(id.getMaxBoms()).maxUsers(id.getMaxUsers()).exportEnabled(id.isExportEnabled()).validityDuration(id.getValidityDuration()).build()).orElse(null);
        return SamAccount.builder().id(details.getAccountId()).firstName(details.getFirstName()).lastName(details.getLastName()).email(details.getEmail()).enabled("ENABLE".equals(details.getStatus())).created(details.getCreated()).sbomConfiguration(sBomConfig).build();
    }

    public SamLinkState getLinkState() {
        return SamLinkContext.get();
    }

    public SamAccountCredentials resetSamAccount(@NonNull String password) {
        return (SamAccountCredentials)Mono.justOrEmpty((Object)this.scarServerProperties.getSamUser()).map(SamAccountCredentials::getEmail).flatMap(email -> this.signInWithPassword(email, password)).flatMap(arg_0 -> ((SamAccountRequester)this.accountsRequester).updateSecretKey(arg_0)).map(SamSecretKeyResponse::getAccountId).flatMap(arg_0 -> this.retrieveCredentials(arg_0)).block();
    }

    private SamAuthTokens getAuthTokens() {
        return SamLinkContext.get().getAuthTokens();
    }

    public Mono<String> getValidAccessToken() {
        return Optional.ofNullable(this.getAuthTokens()).map(SamAuthTokens::getAccessToken).filter(SamAccountService::tokenIsValid).map(Mono::just).orElseGet(() -> this.refreshAccessToken());
    }

    private static boolean tokenIsValid(String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        try {
            Date expiresAt = JWT.decode((String)token).getExpiresAt();
            return expiresAt != null && expiresAt.toInstant().isAfter(Instant.now().plus(15L, ChronoUnit.MINUTES));
        }
        catch (JWTDecodeException ex) {
            return false;
        }
    }

    private Mono<String> refreshAccessToken() {
        return MonoCacheUtils.getOrCreate((AtomicReference)this.ongoingTokenRefresh, () -> Optional.ofNullable(this.getAuthTokens()).map(SamAuthTokens::getRenewalToken).filter(SamAccountService::tokenIsValid).map(arg_0 -> this.renewAccessToken(arg_0)).orElseGet(() -> this.getSecretKey().flatMap(arg_0 -> ((SamAuthenticationRequester)this.authenticationRequester).signInWithSecret(arg_0))).doOnNext(response -> SamLinkContext.updateAuthTokens((SamAuthTokens)SamAccountService.mapTokens((SamAuthTokensResponse)response))).map(SamAuthTokensResponse::getAccessToken).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Performing access token refresh...")).onErrorResume(error -> {
            LOGGER.error("[SAM Access] Error during token refresh", error);
            return Mono.error((Throwable)error);
        }));
    }

    private @NonNull Mono<SamAuthTokensResponse> renewAccessToken(String renewalToken) {
        return this.authenticationRequester.renew(renewalToken);
    }

    public void updateUsageStats() {
        this.usageStatsFetcher.updateSamUsageStats();
    }

    public void requestPasswordReset(SamPasswordResetRequest request) {
        this.publicRequester.requestPasswordReset(request);
    }
}

