/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.requester;

import com.castsoftware.sca.scar.server.analyzer.structure.Component;
import com.castsoftware.sca.scar.server.analyzer.structure.FileElement;
import com.castsoftware.sca.scar.server.sam.configuration.SamClientsProperties;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaDependencyResult;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaFingerprint;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProject;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectVersionList;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaVulnerability;
import com.castsoftware.sca.scar.server.sam.exception.TooManyRequestsWithRetryException;
import com.castsoftware.sca.scar.server.sam.handler.SamRateLimitingExchangeFilter;
import com.castsoftware.sca.scar.server.sam.requester.DataApiRequester;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScaDataApiRequester
implements DataApiRequester {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ScaDataApiRequester.class);
    private static final ParameterizedTypeReference<List<ScaFingerprint>> LIST_OF_FINGERPRINTS = new /* Unavailable Anonymous Inner Class!! */;
    private final WebClient client;
    private final SamClientsProperties.ScaDataApiClientConfiguration configuration;

    public ScaDataApiRequester(WebClient client, SamClientsProperties.ScaDataApiClientConfiguration configuration) {
        this.configuration = configuration;
        this.client = client.mutate().filter((ExchangeFilterFunction)new SamRateLimitingExchangeFilter()).build();
    }

    public List<ScaFingerprint> getFingerprints(@NonNull List<FileElement> files) {
        return (List)this.getClient().get().uri(this.getFingerprintsUri(files)).attribute("operationName", (Object)"Get Fingerprints").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(LIST_OF_FINGERPRINTS).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).flatMap(response -> Mono.justOrEmpty((Object)((List)response.getBody()))).defaultIfEmpty(Collections.emptyList()).block();
    }

    private @NonNull Function<UriBuilder, URI> getFingerprintsUri(List<FileElement> files) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.ScaDataApiPaths)this.configuration.getPaths()).getFingerprint()).queryParam("keys", new Object[]{files.stream().map(FileElement::getSha256).collect(Collectors.joining(","))}).build(new Object[0]);
    }

    public ScaProject getComponent(Component component) {
        Guards.notNull((Object)component);
        return (ScaProject)this.getClient().get().uri(this.getComponentUri(component)).attribute("operationName", (Object)"Get Component").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(ScaProject.class).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).flatMap(response -> Mono.justOrEmpty((Object)((ScaProject)response.getBody()))).block();
    }

    private @NonNull Function<UriBuilder, URI> getComponentUri(Component component) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.ScaDataApiPaths)this.getConfiguration().getPaths()).getProjects()).queryParam("name", new Object[]{StringUtils.defaultIfBlank((CharSequence)component.getScaId(), (CharSequence)component.getName())}).build(new Object[0]);
    }

    public ScaProjectVersionList getComponentVersions(String next) {
        return (ScaProjectVersionList)this.getClient().get().uri(((SamClientsProperties.ScaDataApiPaths)this.getConfiguration().getPaths()).getContext() + Guards.notBlank((String)next), new Object[0]).attribute("operationName", (Object)"Get Component Versions").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(ScaProjectVersionList.class).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).flatMap(response -> Mono.justOrEmpty((Object)((ScaProjectVersionList)response.getBody()))).block();
    }

    public ScaDependencyResult getDependencies(String scaId, String version) {
        return (ScaDependencyResult)this.getClient().get().uri(this.getDependenciesUri(scaId, version)).attribute("operationName", (Object)"Get Dependencies").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(ScaDependencyResult.class).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).onErrorResume(e -> Mono.empty()).flatMap(response -> Mono.justOrEmpty((Object)((ScaDependencyResult)response.getBody()))).block();
    }

    private @NonNull Function<UriBuilder, URI> getDependenciesUri(String scaId, String version) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.ScaDataApiPaths)this.getConfiguration().getPaths()).getDependencies()).queryParam("project", new Object[]{scaId}).queryParam("version", new Object[]{version}).build(new Object[0]);
    }

    public ScaDependencyResult getDependenciesNext(String next) {
        return (ScaDependencyResult)this.getClient().get().uri(((SamClientsProperties.ScaDataApiPaths)this.getConfiguration().getPaths()).getContext() + Guards.notBlank((String)next), new Object[0]).attribute("operationName", (Object)"Get Dependencies (Next)").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(ScaDependencyResult.class).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).onErrorResume(e -> Mono.empty()).flatMap(response -> Mono.justOrEmpty((Object)((ScaDependencyResult)response.getBody()))).block();
    }

    public ScaVulnerability getVulnerability(String name) {
        return (ScaVulnerability)this.getClient().get().uri(this.getVulnerabilityUri(name)).attribute("operationName", (Object)"Get Vulnerability").retrieve().onStatus(arg_0 -> this.isBadRequest(arg_0), arg_0 -> this.errorBadRequest(arg_0)).toEntity(ScaVulnerability.class).retryWhen(ScaDataApiRequester.rateLimitRetrySpec()).flatMap(response -> Mono.justOrEmpty((Object)((ScaVulnerability)response.getBody()))).block();
    }

    private @NonNull Function<UriBuilder, URI> getVulnerabilityUri(String name) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.ScaDataApiPaths)this.configuration.getPaths()).getVulnerability()).queryParam("name", new Object[]{name}).build(new Object[0]);
    }

    private boolean isBadRequest(@NonNull HttpStatusCode statusCode) {
        return !statusCode.equals((Object)HttpStatus.OK) && !HttpStatus.TOO_MANY_REQUESTS.equals((Object)statusCode);
    }

    private static @NonNull Retry rateLimitRetrySpec() {
        return Retry.withThrowable(throwableFlux -> throwableFlux.flatMap(error -> {
            if (error instanceof TooManyRequestsWithRetryException) {
                Duration delay = ((TooManyRequestsWithRetryException)error).getRetryAfter();
                return Mono.delay((Duration)delay);
            }
            return Mono.error((Throwable)error);
        }));
    }

    private @NonNull Mono<? extends Throwable> errorBadRequest(ClientResponse clientResponse) {
        LOGGER.warn(String.format("failed to fetch sca data. error : %s", clientResponse.statusCode()), (Object)clientResponse);
        return Mono.error((Throwable)HttpClientErrorException.create((HttpStatusCode)HttpStatus.BAD_REQUEST, (String)"invalid query (400)", null, null, null));
    }

    @Generated
    public WebClient getClient() {
        return this.client;
    }

    @Generated
    public SamClientsProperties.ScaDataApiClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

