/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.requester;

import com.castsoftware.sca.scar.server.sam.configuration.SamClientsProperties;
import com.castsoftware.sca.scar.server.sam.exception.CannotConnectToSamException;
import com.castsoftware.sca.scar.server.sam.exception.CannotCreateSamAccountException;
import com.castsoftware.sca.scar.server.sam.exception.DuplicateSamAccountException;
import com.castsoftware.sca.scar.server.sam.exception.SamAuthenticationFailedException;
import com.castsoftware.sca.scar.server.sam.exception.UnexpectedSamException;
import com.castsoftware.sca.scar.server.sam.model.request.SamConnectionRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamLoginPasswordRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamSecretKeyRequest;
import com.castsoftware.sca.scar.server.sam.model.request.SamSignUpRequest;
import com.castsoftware.sca.scar.server.sam.model.response.SamAuthTokensResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamSecretKeyResponse;
import com.castsoftware.sca.scar.server.sam.utils.WebClientUtils;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Base64;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class SamAuthenticationRequester {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SamAuthenticationRequester.class);
    private final WebClient client;
    private final SamClientsProperties.SamAuthenticationClientConfiguration configuration;

    public Mono<SamSecretKeyResponse> signUp(SamSignUpRequest signUpRequest) {
        Guards.notNull((Object)signUpRequest);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getClient().post().uri(((SamClientsProperties.SamAuthenticationPaths)this.getConfiguration().getPaths()).getSignUp(), new Object[0])).header("sca-application", new String[]{new String(Base64.getEncoder().encode("sca-reporter".getBytes()))})).attribute("operationName", (Object)"Sign Up")).bodyValue((Object)signUpRequest).retrieve().bodyToMono(SamSecretKeyResponse.class).onErrorMap(WebClientResponseException.Conflict.class, t -> new DuplicateSamAccountException(signUpRequest.getEmail(), (Throwable)t)).onErrorMap(WebClientResponseException.class, t -> new CannotCreateSamAccountException(signUpRequest.getEmail(), (Throwable)t));
    }

    public Mono<SamAuthTokensResponse> signInWithPassword(@NonNull String login, @NonNull String password) {
        return this.signIn((SamConnectionRequest)new SamLoginPasswordRequest(login, password));
    }

    public Mono<SamAuthTokensResponse> signInWithSecret(@NonNull String secret) {
        return this.signIn((SamConnectionRequest)new SamSecretKeyRequest(secret));
    }

    private @NonNull Mono<SamAuthTokensResponse> signIn(@NonNull SamConnectionRequest req) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getClient().post().uri(((SamClientsProperties.SamAuthenticationPaths)this.getConfiguration().getPaths()).getSignIn(), new Object[0])).attribute("operationName", (Object)"Sign In")).bodyValue(Guards.notNull((Object)req)).retrieve().bodyToMono(SamAuthTokensResponse.class).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Signing in with {}...", (Object)("secretToken".equals(req.getType()) ? "secret key" : "credentials"))).doOnSuccess(response -> LOGGER.info("[SAM Access] Successfully authenticated!")).onErrorMap(arg_0 -> this.mapSignInError(arg_0));
    }

    private @NonNull Throwable mapSignInError(Throwable throwable) {
        if (WebClientUtils.isNetworkIssue((Throwable)throwable)) {
            return new CannotConnectToSamException(throwable);
        }
        if (WebClientUtils.isClientError((Throwable)throwable)) {
            return new SamAuthenticationFailedException(throwable);
        }
        return new UnexpectedSamException(throwable);
    }

    public Mono<SamAuthTokensResponse> renew(@NonNull String token) {
        return this.getClient().get().uri(uriBuilder -> uriBuilder.path(((SamClientsProperties.SamAuthenticationPaths)this.getConfiguration().getPaths()).getRenew()).queryParam("token", new Object[]{token}).build(new Object[0])).attribute("operationName", (Object)"Renew Token").retrieve().bodyToMono(SamAuthTokensResponse.class).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Renewing access token...")).doOnSuccess(response -> LOGGER.info("[SAM Access] Access token successfully renewed!"));
    }

    @Generated
    public WebClient getClient() {
        return this.client;
    }

    @Generated
    public SamClientsProperties.SamAuthenticationClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public SamAuthenticationRequester(WebClient client, SamClientsProperties.SamAuthenticationClientConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }
}

