/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.requester;

import com.castsoftware.sca.scar.server.sam.configuration.SamClientsProperties;
import com.castsoftware.sca.scar.server.sam.domain.SamUsageStats;
import com.castsoftware.sca.scar.server.sam.model.request.SamRefreshSecretKeyRequest;
import com.castsoftware.sca.scar.server.sam.model.response.SamAccountDetailsResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamSbomIdentityResponse;
import com.castsoftware.sca.scar.server.sam.model.response.SamSecretKeyResponse;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.net.URI;
import java.util.function.Function;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;
import reactor.core.publisher.Mono;

public class SamAccountRequester {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SamAccountRequester.class);
    private final WebClient client;
    private final SamClientsProperties.SamAccountsClientConfiguration configuration;

    public Mono<SamSecretKeyResponse> updateSecretKey(@NonNull String accountId) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getClient().patch().uri(this.getAccountWithIdUri(Guards.notBlank((String)accountId)))).attribute("operationName", (Object)"Update Secret Key")).bodyValue((Object)new SamRefreshSecretKeyRequest()).retrieve().bodyToMono(SamSecretKeyResponse.class);
    }

    public Mono<SamAccountDetailsResponse> getAccountDetails(@NonNull String accountId) {
        return this.getClient().get().uri(this.getAccountWithIdUri(accountId)).attribute("operationName", (Object)"Get Account Details").retrieve().bodyToMono(SamAccountDetailsResponse.class).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Fetching account details for '{}'...", (Object)accountId)).doOnSuccess(response -> LOGGER.info("[SAM Access] Account details successfully retrieved!"));
    }

    private @NonNull Function<UriBuilder, URI> getAccountWithIdUri(@NonNull String accountId) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.SamAccountsPaths)this.getConfiguration().getPaths()).getAccountWithId()).build(new Object[]{Guards.notBlank((String)accountId)});
    }

    public Mono<SamSbomIdentityResponse> getAccountSBomIdentity(@NonNull String accountId) {
        return this.getClient().get().uri(this.getSBomIdentityForAccountUri(accountId)).attribute("operationName", (Object)"Get SBOM Identity").retrieve().bodyToMono(SamSbomIdentityResponse.class).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Fetching account SBOM identity for '{}'...", (Object)accountId)).doOnSuccess(response -> LOGGER.info("[SAM Access] Account SBOM identity successfully retrieved!"));
    }

    private @NonNull Function<UriBuilder, URI> getSBomIdentityForAccountUri(@NonNull String accountId) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.SamAccountsPaths)this.getConfiguration().getPaths()).getSbomIdentityForAccount()).build(new Object[]{Guards.notBlank((String)accountId)});
    }

    public Mono<Void> updateUsageStats(@NonNull String accountId, @NonNull SamUsageStats request) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.getClient().put().uri(this.getUpdateUsageStatsUri(Guards.notBlank((String)accountId)))).attribute("operationName", (Object)"Update Usage Stats")).bodyValue(Guards.notNull((Object)request)).retrieve().bodyToMono(Void.class).doOnSubscribe(sub -> LOGGER.info("[SAM Access] Updating SCA/SBOM usage statistics for '{}'...", (Object)accountId)).doOnSuccess(resp -> LOGGER.info("[SAM Access] Usage statistics successfully updated!"));
    }

    private @NonNull Function<UriBuilder, URI> getUpdateUsageStatsUri(@NonNull String accountId) {
        return uriBuilder -> uriBuilder.path(((SamClientsProperties.SamAccountsPaths)this.getConfiguration().getPaths()).getUsageStatsForAccount()).build(new Object[]{Guards.notBlank((String)accountId)});
    }

    @Generated
    public WebClient getClient() {
        return this.client;
    }

    @Generated
    public SamClientsProperties.SamAccountsClientConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public SamAccountRequester(WebClient client, SamClientsProperties.SamAccountsClientConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }
}

