/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.ioc;

import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.configuration.ServiceClientProperties;
import com.castsoftware.sca.scar.server.application.ioc.BaseWebClientSupplier;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.message.MessageService;
import com.castsoftware.sca.scar.server.sam.configuration.SamClientsProperties;
import com.castsoftware.sca.scar.server.sam.handler.AuthenticatedSamWebClientFactory;
import com.castsoftware.sca.scar.server.sam.handler.SamUsageStatsUpdater;
import com.castsoftware.sca.scar.server.sam.handler.SamWebClientFactory;
import com.castsoftware.sca.scar.server.sam.launcher.SamConnectionLauncher;
import com.castsoftware.sca.scar.server.sam.launcher.SamVersionCheckLauncher;
import com.castsoftware.sca.scar.server.sam.requester.SamAccountRequester;
import com.castsoftware.sca.scar.server.sam.requester.SamAuthenticationRequester;
import com.castsoftware.sca.scar.server.sam.requester.SamInfoRequester;
import com.castsoftware.sca.scar.server.sam.requester.SamPublicRequester;
import com.castsoftware.sca.scar.server.sam.requester.ScaDataApiRequester;
import com.castsoftware.sca.scar.server.sam.service.SamAccountService;
import com.castsoftware.sca.scar.server.sam.service.SamVersionCheckService;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import java.time.Duration;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import reactor.core.scheduler.Schedulers;
import reactor.netty.resources.ConnectionProvider;

@Configuration
public class SamServicesIOC {
    @Bean
    @ConfigurationProperties(value="sca.clients.sam")
    public SamClientsProperties samClientsConfiguration() {
        return new SamClientsProperties();
    }

    @Bean
    public ConnectionProvider samConnectionProvider() {
        return ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"sam-connection-pool").maxConnections(100)).maxIdleTime(Duration.ofSeconds(30L))).maxLifeTime(Duration.ofMinutes(5L))).pendingAcquireMaxCount(200)).pendingAcquireTimeout(Duration.ofSeconds(10L))).evictInBackground(Duration.ofSeconds(60L))).build();
    }

    @Bean
    public SamWebClientFactory samWebClientFactory(@Value(value="sca.application") String applicationName, BaseWebClientSupplier webClientSupplier, ConnectionProvider samConnectionProvider) {
        return new SamWebClientFactory(applicationName, webClientSupplier, samConnectionProvider);
    }

    @Bean
    public SamAuthenticationRequester samAuthenticationRequester(SamWebClientFactory webClientFactory, SamClientsProperties clientsConfiguration) {
        SamClientsProperties.SamAuthenticationClientConfiguration config = clientsConfiguration.getSecurity().getAuthentication();
        return new SamAuthenticationRequester(webClientFactory.build((ServiceClientProperties)config), config);
    }

    @Bean
    public SamPublicRequester samPublicRequester(SamWebClientFactory webClientFactory, SamClientsProperties clientsConfiguration) {
        SamClientsProperties.SamPublicClientConfiguration config = clientsConfiguration.getServices().getPublik();
        return new SamPublicRequester(webClientFactory.build((ServiceClientProperties)config), config);
    }

    @Bean
    public SamUsageStatsUpdater samUsageStatsFetcher(BomDao bomDao, UserDao userDao, Supplier<String> serverVersionSupplier, ScarServerProperties scarServerProperties, SamAccountRequester accountRequester) {
        return new SamUsageStatsUpdater(bomDao, userDao, serverVersionSupplier, scarServerProperties, accountRequester);
    }

    @Bean
    public SamAccountService samAccountService(ScarServerProperties scarServerProperties, SamAuthenticationRequester authenticationRequester, @Lazy SamAccountRequester accountsRequester, @Lazy SamPublicRequester publicRequester, @Lazy SamUsageStatsUpdater usageStatsFetcher) {
        return new SamAccountService(scarServerProperties, authenticationRequester, accountsRequester, publicRequester, usageStatsFetcher);
    }

    @Bean
    public AuthenticatedSamWebClientFactory authenticatedSamWebClientFactory(SamWebClientFactory samWebClientFactory, SamAccountService samAccountService) {
        return new AuthenticatedSamWebClientFactory(samWebClientFactory, samAccountService);
    }

    @Bean
    public SamAccountRequester samAccountsRequester(AuthenticatedSamWebClientFactory samWebClientFactory, SamClientsProperties clientsConfiguration) {
        SamClientsProperties.SamAccountsClientConfiguration config = clientsConfiguration.getServices().getAccounts();
        return new SamAccountRequester(samWebClientFactory.build((ServiceClientProperties)config), config);
    }

    @Bean
    public ScaDataApiRequester scaDataApiRequester(AuthenticatedSamWebClientFactory samWebClientFactory, SamClientsProperties clientsConfiguration) {
        SamClientsProperties.ScaDataApiClientConfiguration config = clientsConfiguration.getServices().getData();
        return new ScaDataApiRequester(samWebClientFactory.build((ServiceClientProperties)config), config);
    }

    @Bean
    @ConditionalOnProperty(prefix="sca.scar", name={"mode"}, havingValue="INITIALIZED")
    public SamConnectionLauncher samConnectionLauncher(SamAccountService samAccountService) {
        return new SamConnectionLauncher(samAccountService);
    }

    @Bean
    public SamInfoRequester samInfoRequester(AuthenticatedSamWebClientFactory samWebClientFactory, SamClientsProperties clientsProperties) {
        SamClientsProperties.SamInfoClientConfiguration config = clientsProperties.getServices().getInfo();
        return new SamInfoRequester(samWebClientFactory.build((ServiceClientProperties)config), config);
    }

    @Bean
    public SamVersionCheckService samVersionCheckService(SamInfoRequester samInfoRequester, MessageService messageService, SamClientsProperties clientsProperties, Supplier<String> serverVersionSupplier) {
        SamClientsProperties.SamVersionCheckProperties config = clientsProperties.getVersionCheck();
        return new SamVersionCheckService(samInfoRequester, messageService, config, serverVersionSupplier.get(), Schedulers.parallel());
    }

    @Bean
    @ConditionalOnProperty(prefix="sca.scar", name={"mode"}, havingValue="INITIALIZED")
    public SamVersionCheckLauncher samVersionCheckLauncher(SamVersionCheckService versionCheckService) {
        return new SamVersionCheckLauncher(versionCheckService);
    }
}

