/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.application.configuration.ServiceClientProperties;
import com.castsoftware.sca.scar.server.application.ioc.BaseWebClientSupplier;
import com.castsoftware.sca.scar.server.sam.handler.NetworkRetryExchangeFilter;
import com.castsoftware.sca.scar.server.sam.utils.WebClientUtils;
import com.castsoftware.sca.util.java.Guards;
import java.util.Base64;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.resources.ConnectionProvider;

public class SamWebClientFactory {
    private final String applicationName;
    private final BaseWebClientSupplier webClientSupplier;
    private final ConnectionProvider connectionProvider;

    public SamWebClientFactory(@NonNull String applicationName, @NonNull BaseWebClientSupplier webClientSupplier, @NonNull ConnectionProvider connectionProvider) {
        this.applicationName = Guards.notBlank((String)applicationName);
        this.webClientSupplier = (BaseWebClientSupplier)Guards.notNull((Object)webClientSupplier);
        this.connectionProvider = (ConnectionProvider)Guards.notNull((Object)connectionProvider);
    }

    public @NonNull WebClient build(ServiceClientProperties<?> configuration) {
        return this.webClientSupplier.get().defaultHeader("sca-application", new String[]{Base64.getEncoder().encodeToString(this.applicationName.getBytes())}).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Content-Type", new String[]{"application/json"}).filter((ExchangeFilterFunction)new NetworkRetryExchangeFilter(configuration)).baseUrl(WebClientUtils.baseUrl(configuration)).clientConnector(WebClientUtils.clientConnector(configuration, (ConnectionProvider)this.connectionProvider)).build();
    }
}

