/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.application.configuration.ScarServerProperties;
import com.castsoftware.sca.scar.server.application.domain.ApplicationConnectionType;
import com.castsoftware.sca.scar.server.bom.dao.BomDao;
import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.domain.SamUsageStats;
import com.castsoftware.sca.scar.server.sam.handler.SamLinkContext;
import com.castsoftware.sca.scar.server.sam.requester.SamAccountRequester;
import com.castsoftware.sca.scar.server.user.dao.UserDao;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import reactor.core.publisher.Mono;

public class SamUsageStatsUpdater {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(SamUsageStatsUpdater.class);
    private final BomDao bomDao;
    private final UserDao userDao;
    private final String serverVersion;
    private final ScarServerProperties scarServerProperties;
    private final SamAccountRequester accountRequester;

    public SamUsageStatsUpdater(BomDao bomDao, UserDao userDao, @NonNull Supplier<String> serverVersionSupplier, ScarServerProperties scarServerProperties, SamAccountRequester accountRequester) {
        this.bomDao = bomDao;
        this.userDao = userDao;
        this.serverVersion = (String)((Supplier)Guards.notNull(serverVersionSupplier)).get();
        this.scarServerProperties = scarServerProperties;
        this.accountRequester = accountRequester;
    }

    public void updateSamUsageStats() {
        Optional<String> optAccountId = Optional.of(SamLinkContext.get()).map(SamLinkState::getSamAccount).map(SamAccount::getId);
        if (optAccountId.isEmpty()) {
            LOGGER.error("[SAM Access] Unable to update SCA/SBOM usage statistics. Missing linked account id.");
            return;
        }
        String accountId = optAccountId.get();
        this.accountRequester.updateUsageStats(accountId, this.getSamUsageStats()).doOnError(e -> LOGGER.error("[SAM Access] Unable to update SCA/SBOM usage statistics", e)).onErrorResume(e -> Mono.empty()).block();
    }

    private @NonNull SamUsageStats getSamUsageStats() {
        Integer sBomCount = this.bomDao.countAll().map(Long::intValue).orElseThrow(Suppliers.illegalState((String)"Cannot count available SBOMs"));
        Integer userCount = this.userDao.countAll().map(Long::intValue).orElseThrow(Suppliers.illegalState((String)"Cannot count registered Users"));
        ApplicationConnectionType connectionType = this.scarServerProperties.getConnectionType();
        return new SamUsageStats(sBomCount, Integer.valueOf(ApplicationConnectionType.SINGLE_USER.equals((Object)connectionType) ? 1 : userCount), connectionType, this.serverVersion);
    }
}

