/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.sam.exception.TooManyRequestsWithRetryException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class SamRateLimitingExchangeFilter
implements ExchangeFilterFunction {
    public @NonNull Mono<ClientResponse> filter(@NonNull ClientRequest request, ExchangeFunction next) {
        return next.exchange(request).flatMap(response -> {
            if (response.statusCode().equals((Object)HttpStatus.TOO_MANY_REQUESTS)) {
                return TooManyRequestsWithRetryException.create((ClientResponse)response).flatMap(Mono::error);
            }
            return Mono.just((Object)response);
        });
    }
}

