/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.sam.domain.SamAccount;
import com.castsoftware.sca.scar.server.sam.domain.SamAuthTokens;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkState;
import com.castsoftware.sca.scar.server.sam.domain.SamLinkStatus;
import java.util.concurrent.atomic.AtomicReference;

public class SamLinkContext {
    private static final AtomicReference<SamLinkState> linkState = new AtomicReference<SamLinkState>(new SamLinkState(null, null, null, SamLinkStatus.UNKNOWN));

    public static SamLinkState get() {
        return (SamLinkState)linkState.get();
    }

    public static SamLinkState updateSecretKey(String secretKey) {
        return (SamLinkState)linkState.updateAndGet(state -> state.withSecretKey(secretKey));
    }

    public static SamLinkState updateAuthTokens(SamAuthTokens authTokens) {
        return (SamLinkState)linkState.updateAndGet(state -> state.withAuthTokens(authTokens));
    }

    public static SamLinkState updateSamAccount(SamAccount samAccount) {
        return (SamLinkState)linkState.updateAndGet(state -> state.withSamAccount(samAccount));
    }

    public static SamLinkState updateLinkStatus(SamLinkStatus status) {
        return (SamLinkState)linkState.updateAndGet(state -> state.withLinkStatus(status));
    }
}

