/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.application.configuration.ServiceClientProperties;
import com.castsoftware.sca.scar.server.sam.exception.TooManyRequestsWithRetryException;
import com.castsoftware.sca.scar.server.sam.utils.WebClientUtils;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Duration;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class NetworkRetryExchangeFilter
implements ExchangeFilterFunction {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(NetworkRetryExchangeFilter.class);
    private final String clientName;
    private final Duration defaultTimeout;

    public NetworkRetryExchangeFilter(@NonNull ServiceClientProperties<?> configuration) {
        this.clientName = configuration.getName();
        this.defaultTimeout = Duration.ofSeconds(15L);
    }

    public @NonNull Mono<ClientResponse> filter(@NonNull ClientRequest request, @NonNull ExchangeFunction next) {
        String operationName = request.attribute("operationName").map(Object::toString).orElse(String.valueOf(request.method()) + " " + request.url().getPath());
        String logContext = this.clientName + " - " + operationName;
        return next.exchange(request).timeout(this.defaultTimeout).retryWhen(WebClientUtils.networkRetryWithBackoff((String)logContext)).doOnError(error -> {
            if (!(error instanceof TooManyRequestsWithRetryException)) {
                LOGGER.error("[SAM {}] Request failed after retries: {} {}", new Object[]{logContext, request.method(), request.url().getPath(), error});
            }
        });
    }
}

