/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.handler;

import com.castsoftware.sca.scar.server.application.configuration.ServiceClientProperties;
import com.castsoftware.sca.scar.server.sam.handler.SamWebClientFactory;
import com.castsoftware.sca.scar.server.sam.service.SamAccountService;
import com.castsoftware.sca.util.java.Guards;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

public class AuthenticatedSamWebClientFactory {
    private final SamWebClientFactory samWebClientFactory;
    private final SamAccountService samAccountService;

    public AuthenticatedSamWebClientFactory(@NonNull SamWebClientFactory samWebClientFactory, @NonNull SamAccountService samAccountService) {
        this.samWebClientFactory = (SamWebClientFactory)Guards.notNull((Object)samWebClientFactory);
        this.samAccountService = (SamAccountService)Guards.notNull((Object)samAccountService);
    }

    public WebClient build(ServiceClientProperties<?> configuration) {
        return this.samWebClientFactory.build(configuration).mutate().filter(this.authorizationFilter()).build();
    }

    private @NonNull ExchangeFilterFunction authorizationFilter() {
        return ExchangeFilterFunction.ofRequestProcessor(request -> this.samAccountService.getValidAccessToken().map(token -> ClientRequest.from((ClientRequest)request).headers(h -> h.setBearerAuth(token)).build()));
    }
}

