/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.exception;

import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
public class TooManyRequestsWithRetryException
extends WebClientResponseException {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(TooManyRequestsWithRetryException.class);
    private static final Duration DEFAULT_RETRY_AFTER_DURATION = Duration.ofSeconds(5L);
    private final Duration retryAfter;

    public TooManyRequestsWithRetryException(String message, @NonNull HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] responseBody, Charset responseCharset, Duration retryAfter) {
        super(message, statusCode.value(), statusText, headers, responseBody, responseCharset);
        this.retryAfter = retryAfter;
    }

    public static @NonNull Mono<Throwable> create(@NonNull ClientResponse clientResponse) {
        Charset responseCharset = clientResponse.headers().contentType().map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
        return clientResponse.bodyToMono(String.class).defaultIfEmpty((Object)"No response body").flatMap(body -> {
            Duration retryAfterDuration = TooManyRequestsWithRetryException.parseRetryAfterHeader((ClientResponse)clientResponse);
            String message = String.format("Received 429 Too Many Requests. Retrying after %d seconds. Response body: %s", retryAfterDuration.toSeconds(), body);
            return Mono.error((Throwable)new TooManyRequestsWithRetryException(message, clientResponse.statusCode(), "", clientResponse.headers().asHttpHeaders(), body.getBytes(responseCharset), responseCharset, retryAfterDuration));
        });
    }

    private static Duration parseRetryAfterHeader(@NonNull ClientResponse clientResponse) {
        return Optional.ofNullable(clientResponse.headers().asHttpHeaders().get((Object)"X-RateLimit-Reset")).flatMap(headers -> headers.stream().findFirst()).map(value -> {
            try {
                long seconds = Long.parseLong(value);
                return Duration.ofSeconds(Math.max(seconds, 1L));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Warning: Could not parse 'X-RateLimit-Reset' header as seconds: " + value + ". Using default.");
                return DEFAULT_RETRY_AFTER_DURATION;
            }
        }).orElse(DEFAULT_RETRY_AFTER_DURATION);
    }

    @Generated
    public Duration getRetryAfter() {
        return this.retryAfter;
    }
}

