/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.sam.domain.data;

import com.castsoftware.sca.scar.server.sam.domain.data.ScaHref;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectMetric;
import com.castsoftware.sca.scar.server.sam.domain.data.ScaProjectVersion;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ScaProject {
    private String name;
    private String description;
    private String url;
    private String homepage;
    private String repository;
    private String repositoryType;
    private Set<ScaProjectVersion> versions;
    private ScaProjectVersion lastVersion;
    private Set<ScaProjectMetric> metrics;
    private Set<String> licenses;
    private Set<String> languages;
    private Set<String> topics;
    private ScaHref href;

    public Set<ScaProjectVersion> getVersions() {
        if (this.versions == null) {
            this.versions = new HashSet();
        }
        return this.versions;
    }

    public void addVersions(Set<ScaProjectVersion> versions) {
        this.getVersions().addAll(versions);
    }

    public void setMetrics(String metricsAggregated) {
        this.metrics = Optional.ofNullable(metricsAggregated).map(m -> Arrays.stream(m.split(";")).map(p -> {
            String[] split = p.split(":");
            ScaProjectMetric metric = new ScaProjectMetric();
            metric.setKey(split[0]);
            metric.setValue(Integer.parseInt(split[1]));
            return metric;
        }).collect(Collectors.toSet())).orElseGet(HashSet::new);
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    @Generated
    public void setRepository(String repository) {
        this.repository = repository;
    }

    @Generated
    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    @Generated
    public void setVersions(Set<ScaProjectVersion> versions) {
        this.versions = versions;
    }

    @Generated
    public void setLastVersion(ScaProjectVersion lastVersion) {
        this.lastVersion = lastVersion;
    }

    @Generated
    public void setLicenses(Set<String> licenses) {
        this.licenses = licenses;
    }

    @Generated
    public void setLanguages(Set<String> languages) {
        this.languages = languages;
    }

    @Generated
    public void setTopics(Set<String> topics) {
        this.topics = topics;
    }

    @Generated
    public void setHref(ScaHref href) {
        this.href = href;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getHomepage() {
        return this.homepage;
    }

    @Generated
    public String getRepository() {
        return this.repository;
    }

    @Generated
    public String getRepositoryType() {
        return this.repositoryType;
    }

    @Generated
    public ScaProjectVersion getLastVersion() {
        return this.lastVersion;
    }

    @Generated
    public Set<ScaProjectMetric> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Set<String> getLicenses() {
        return this.licenses;
    }

    @Generated
    public Set<String> getLanguages() {
        return this.languages;
    }

    @Generated
    public Set<String> getTopics() {
        return this.topics;
    }

    @Generated
    public ScaHref getHref() {
        return this.href;
    }
}

