/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.risk;

import com.castsoftware.antepedia.tools.semverTool.VersionParser;
import com.castsoftware.antepedia.tools.semverTool.expression.Version;
import com.castsoftware.antepedia.tools.semverTool.internal.Parser;
import com.castsoftware.sca.scar.server.risk.ObsolescenceLevel;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObsolescenceComputer {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(ObsolescenceComputer.class);
    private static final long OUTDATED_THRESHOLD_YEARS = 5L;
    private static final long HIGH_OBSOLESCENCE_YEARS = 2L;
    private static final long MEDIUM_OBSOLESCENCE_YEARS = 1L;
    private static final long LOW_OBSOLESCENCE_MONTHS = 6L;
    private static final int HIGH_SEMVER_THRESHOLD = 110;
    private static final int MEDIUM_SEMVER_THRESHOLD = 21;
    private static final int LOW_SEMVER_THRESHOLD = 3;

    public static ObsolescenceLevel compute(@Nullable String currentVersion, @Nullable String latestVersion, @Nullable Map<String, Long> allVersions) {
        if (latestVersion == null || currentVersion == null) {
            return ObsolescenceLevel.UNKNOWN;
        }
        if (ObsolescenceComputer.isOutdated((String)latestVersion, allVersions)) {
            return ObsolescenceLevel.OUTDATED;
        }
        try {
            return ObsolescenceComputer.computeBySemver((String)currentVersion, (String)latestVersion);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to compute obsolescence by semver for versions {} -> {}: {}", new Object[]{currentVersion, latestVersion, e.getMessage()});
            try {
                return ObsolescenceComputer.computeByDate((String)currentVersion, (String)latestVersion, allVersions);
            }
            catch (Exception e2) {
                LOGGER.debug("Failed to compute obsolescence by date for versions {} -> {}: {}", new Object[]{currentVersion, latestVersion, e2.getMessage()});
                return ObsolescenceLevel.UNKNOWN;
            }
        }
    }

    private static boolean isOutdated(@Nullable String latestVersion, @Nullable Map<String, Long> allVersions) {
        if (allVersions != null && allVersions.containsKey(latestVersion)) {
            Long timestamp = allVersions.get(latestVersion);
            if (timestamp == null) {
                return false;
            }
            LocalDateTime releaseDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC);
            long yearsSinceRelease = ChronoUnit.YEARS.between(releaseDate, LocalDateTime.now(ZoneOffset.UTC));
            return yearsSinceRelease > 5L;
        }
        return false;
    }

    private static ObsolescenceLevel computeBySemver(String currentVersion, String latestVersion) {
        Version latest;
        Parser parser = VersionParser.instance();
        Version version = (Version)parser.parse(currentVersion);
        int score = ObsolescenceComputer.computeSemverDiff((Version)version, (Version)(latest = (Version)parser.parse(latestVersion)));
        if (score >= 110) {
            return ObsolescenceLevel.HIGH;
        }
        if (score >= 21) {
            return ObsolescenceLevel.MEDIUM;
        }
        if (score >= 3) {
            return ObsolescenceLevel.LOW;
        }
        return ObsolescenceLevel.UPTODATE;
    }

    private static int computeSemverDiff(@NonNull Version currentVersion, @NonNull Version latestVersion) {
        int patchDiff;
        int minorDiff;
        int score = 0;
        int majorDiff = latestVersion.getMajor() - currentVersion.getMajor();
        if (majorDiff > 0) {
            score += 100 * majorDiff;
        }
        if (latestVersion.getMajor() >= currentVersion.getMajor() && (minorDiff = latestVersion.getMinor() - currentVersion.getMinor()) > 0) {
            score += 10 * minorDiff;
        }
        if (latestVersion.getMajor() >= currentVersion.getMajor() && latestVersion.getMinor() >= currentVersion.getMinor() && (patchDiff = latestVersion.getPatch() - currentVersion.getPatch()) > 0) {
            score += patchDiff;
        }
        return score;
    }

    private static ObsolescenceLevel computeByDate(String currentVersion, String latestVersion, Map<String, Long> allVersions) {
        if (!allVersions.containsKey(latestVersion) || !allVersions.containsKey(currentVersion)) {
            return ObsolescenceLevel.UNKNOWN;
        }
        Long latestTimestamp = allVersions.get(latestVersion);
        Long currentTimestamp = allVersions.get(currentVersion);
        if (latestTimestamp == null || currentTimestamp == null) {
            return ObsolescenceLevel.UNKNOWN;
        }
        LocalDateTime latestDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(latestTimestamp), ZoneOffset.UTC);
        LocalDateTime versionDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(currentTimestamp), ZoneOffset.UTC);
        long yearsDiff = ChronoUnit.YEARS.between(versionDate, latestDate);
        if (yearsDiff >= 2L) {
            return ObsolescenceLevel.HIGH;
        }
        if (yearsDiff >= 1L) {
            return ObsolescenceLevel.MEDIUM;
        }
        long monthsDiff = ChronoUnit.MONTHS.between(versionDate, latestDate);
        if (monthsDiff >= 6L) {
            return ObsolescenceLevel.LOW;
        }
        return ObsolescenceLevel.UPTODATE;
    }

    @Generated
    private ObsolescenceComputer() {
    }
}

