/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.preference.service;

import com.castsoftware.sca.scar.server.message.MessageRepository;
import com.castsoftware.sca.scar.server.message.MessageType;
import com.castsoftware.sca.scar.server.preference.domain.BomPreferences;
import com.castsoftware.sca.scar.server.preference.domain.BomType;
import com.castsoftware.sca.scar.server.preference.domain.ReviewStep;
import com.castsoftware.sca.scar.server.preference.domain.ScannerPreferences;
import com.castsoftware.sca.scar.server.preference.domain.TableDefinition;
import com.castsoftware.sca.scar.server.preference.domain.TablePreferences;
import com.castsoftware.sca.scar.server.preference.exception.PreferenceExceptions;
import com.castsoftware.sca.scar.server.preference.model.request.BomPreferencesRequest;
import com.castsoftware.sca.scar.server.preference.model.request.ScannerPreferencesRequest;
import com.castsoftware.sca.scar.server.preference.model.request.TablePreferencesRequest;
import com.castsoftware.sca.scar.server.preference.repository.BomPreferencesRepository;
import com.castsoftware.sca.scar.server.preference.repository.ReviewStepsRepository;
import com.castsoftware.sca.scar.server.preference.repository.ScannerPreferencesRepository;
import com.castsoftware.sca.scar.server.preference.repository.TablePreferencesRepository;
import com.castsoftware.sca.util.java.Suppliers;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PreferencesService {
    private static final Integer DEFAULT_ROWS_PER_PAGE = 25;
    private final ScannerPreferencesRepository scannerPrefsRepository;
    private final TablePreferencesRepository tablePrefsRepository;
    private final BomPreferencesRepository bomPreferencesRepository;
    private final ReviewStepsRepository reviewStepsRepository;
    private final MessageRepository messageRepository;

    public PreferencesService(ScannerPreferencesRepository scannerPrefsRepository, TablePreferencesRepository tablePrefsRepository, BomPreferencesRepository bomPreferencesRepository, ReviewStepsRepository reviewStepsRepository, MessageRepository messageRepository) {
        this.scannerPrefsRepository = scannerPrefsRepository;
        this.tablePrefsRepository = tablePrefsRepository;
        this.bomPreferencesRepository = bomPreferencesRepository;
        this.reviewStepsRepository = reviewStepsRepository;
        this.messageRepository = messageRepository;
    }

    public ScannerPreferences getScannerPreferences() {
        return this.scannerPrefsRepository.getPreferences().orElse(new ScannerPreferences());
    }

    public void updateScannerPreferences(@NonNull ScannerPreferencesRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getRootFolderId())) {
            this.validateFolderExists(request.getRootFolderId(), "Root folder");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getLocalRepositoryFolderId())) {
            this.validateFolderExists(request.getLocalRepositoryFolderId(), "Repository folder");
        }
        ScannerPreferences prefs = new ScannerPreferences();
        prefs.setRootFolderId(request.getRootFolderId());
        prefs.setLocalRepositoryFolderId(request.getLocalRepositoryFolderId());
        this.scannerPrefsRepository.setPreferences(prefs);
        if (StringUtils.isNotBlank((CharSequence)prefs.getRootFolderId()) && StringUtils.isNotBlank((CharSequence)prefs.getLocalRepositoryFolderId())) {
            this.messageRepository.deleteMessagesByType(MessageType.SCANNER_CONFIG);
        }
    }

    private void validateFolderExists(String folderId, String folderName) {
        String decodedPath;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(folderId);
            decodedPath = new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(folderName + " ID is not valid base64: " + folderId, e);
        }
        Path folderPath = Paths.get(decodedPath, new String[0]);
        if (!Files.exists(folderPath, new LinkOption[0])) {
            throw new RuntimeException(folderName + " does not exist: " + decodedPath);
        }
        if (!Files.isDirectory(folderPath, new LinkOption[0])) {
            throw new RuntimeException(folderName + " is not a directory: " + decodedPath);
        }
    }

    public TablePreferences getTablePreferences(String tableName) {
        TableDefinition definition = this.validTable(tableName);
        return (TablePreferences)this.tablePrefsRepository.findByTableName(definition.name()).orElseThrow(() -> PreferenceExceptions.tablePreferencesNotFound((String)definition.name()));
    }

    public void updateTablePreferences(String tableName, TablePreferencesRequest request) {
        TableDefinition definition = this.validTable(tableName);
        TablePreferences preferences = this.tablePrefsRepository.findByTableName(definition.name()).orElse(new TablePreferences());
        Optional<TablePreferencesRequest> oRequest = Optional.ofNullable(request);
        preferences.setRowsPerPage(oRequest.map(TablePreferencesRequest::getRowsPerPage).orElse(DEFAULT_ROWS_PER_PAGE));
        Set required = definition.getRequiredColumnDefs();
        preferences.setColumns((List)oRequest.map(TablePreferencesRequest::getColumns).orElseGet(LinkedList::new).stream().map(c -> (TableDefinition.ColumnDef)definition.getColumn(c).orElseThrow(Suppliers.illegalArgument((String)("Unknown column '" + c + "'")))).peek(required::remove).map(TableDefinition.ColumnDef::getName).collect(Collectors.toCollection(LinkedList::new)));
        Optional.of(required).filter(Collection::isEmpty).orElseThrow(Suppliers.illegalArgument((String)"Missing required columns"));
        this.tablePrefsRepository.setTablePreferences(preferences);
    }

    private TableDefinition validTable(@NonNull String tableName) {
        return Optional.ofNullable((TableDefinition)EnumUtils.getEnum(TableDefinition.class, (String)tableName.toUpperCase())).orElseThrow(Suppliers.illegalArgument((String)"Unknown table name"));
    }

    public BomPreferences getBomPreferences(String type) {
        BomType bomType = this.validBomType(type);
        return this.bomPreferencesRepository.findByType(bomType.name()).orElse(new BomPreferences(bomType.name()));
    }

    public void updateBomPreferences(String type, @NonNull BomPreferencesRequest request) {
        BomType bomType = this.validBomType(type);
        BomPreferences prefs = new BomPreferences(bomType.name());
        prefs.setMoveSplitComponents(request.isMoveSplitComponents());
        prefs.setMoveMergedComponents(request.isMoveMergedComponents());
        prefs.setDefaultComponentLicensePropagation(request.isDefaultComponentLicensePropagation());
        prefs.setDefaultFileLicensePropagation(request.isDefaultFileLicensePropagation());
        if (BomType.CATALOG.equals((Object)bomType)) {
            prefs.setDefaultLinkedComponentPropagation(Boolean.valueOf(request.isDefaultLinkedComponentPropagation()));
        }
        this.bomPreferencesRepository.updateBomPrefs(prefs);
    }

    private BomType validBomType(@NonNull String type) {
        return Optional.ofNullable((BomType)EnumUtils.getEnum(BomType.class, (String)type.toUpperCase())).orElseThrow(Suppliers.illegalArgument((String)"Unknown type"));
    }

    public List<ReviewStep> getReviewSteps() {
        return this.reviewStepsRepository.getSteps().orElse(new ArrayList());
    }

    public Optional<ReviewStep> findReviewStep(int index) {
        return this.reviewStepsRepository.getSteps().orElse(List.of()).stream().filter(s -> s.getIndex().equals(index)).findFirst();
    }
}

