/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.preference.domain;

import com.castsoftware.sca.scar.server.preference.domain.TableDefinition;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TableDefinition {
    BOM_COMPONENTS(Stream.of(ColumnDef.required((String)"NAME"), ColumnDef.optional((String)"VERSION"), ColumnDef.optional((String)"LATEST"), ColumnDef.optional((String)"OBSOLESCENCE"), ColumnDef.optional((String)"VULNERABILITIES"), ColumnDef.optional((String)"LICENSES"), ColumnDef.optional((String)"PATH"), ColumnDef.optional((String)"SCA_ID"), ColumnDef.required((String)"FILES"), ColumnDef.optional((String)"SOURCE"), ColumnDef.optional((String)"COPYRIGHT")).collect(Collectors.toSet())),
    BOM_FILES(Stream.of(ColumnDef.required((String)"NAME"), ColumnDef.required((String)"EXTENSION"), ColumnDef.required((String)"VERSION"), ColumnDef.optional((String)"SIZE"), ColumnDef.required((String)"PATH"), ColumnDef.optional((String)"LICENSES"), ColumnDef.optional((String)"SHA256"), ColumnDef.optional((String)"COPYRIGHT")).collect(Collectors.toSet())),
    CATALOG_COMPONENTS(Stream.of(ColumnDef.required((String)"NAME"), ColumnDef.optional((String)"VERSION"), ColumnDef.optional((String)"LATEST"), ColumnDef.optional((String)"OBSOLESCENCE"), ColumnDef.optional((String)"VULNERABILITIES"), ColumnDef.optional((String)"LICENSES"), ColumnDef.optional((String)"SCA_ID"), ColumnDef.required((String)"FILES"), ColumnDef.optional((String)"COPYRIGHT")).collect(Collectors.toSet())),
    CATALOG_FILES(Stream.of(ColumnDef.required((String)"NAME"), ColumnDef.required((String)"EXTENSION"), ColumnDef.required((String)"VERSION"), ColumnDef.optional((String)"SIZE"), ColumnDef.optional((String)"LICENSES"), ColumnDef.optional((String)"SHA256"), ColumnDef.optional((String)"COPYRIGHT")).collect(Collectors.toSet())),
    VERSIONS(Stream.of(ColumnDef.required((String)"VERSION"), ColumnDef.required((String)"STEP"), ColumnDef.optional((String)"FILES"), ColumnDef.optional((String)"COMPONENTS"), ColumnDef.optional((String)"LICENSES"), ColumnDef.optional((String)"VULNERABILITIES"), ColumnDef.optional((String)"CREATED"), ColumnDef.optional((String)"UPDATED")).collect(Collectors.toSet()));

    private final Set<ColumnDef> columnsDefs;

    private TableDefinition(Set<ColumnDef> columnsDefs) {
        this.columnsDefs = columnsDefs;
    }

    public Set<ColumnDef> getColumnsDefs() {
        return this.columnsDefs;
    }

    public Optional<ColumnDef> getColumn(String name) {
        return this.getColumnsDefs().stream().filter(c -> c.getName().equalsIgnoreCase(name)).findFirst();
    }

    public Set<ColumnDef> getRequiredColumnDefs() {
        return this.getColumnsDefs().stream().filter(ColumnDef::isRequired).collect(Collectors.toSet());
    }
}

