/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.structure;

import java.util.Optional;
import java.util.function.Supplier;

public class EditRecorder {
    private boolean active = false;
    private boolean edited = false;

    public void activate() {
        this.active = true;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited() {
        this.edited = true;
    }

    public <T> void record(T oldValue, T newValue, Supplier<T> defaultValue) {
        this.record(this.resolveValue(oldValue, defaultValue), this.resolveValue(newValue, defaultValue));
    }

    private <T> T resolveValue(T value, Supplier<T> defaultValue) {
        return Optional.ofNullable(value).orElseGet(defaultValue != null ? defaultValue : () -> null);
    }

    public <T> void record(T oldValue, T newValue, T defaultValue) {
        this.record(Optional.ofNullable(oldValue).orElse(defaultValue), Optional.ofNullable(newValue).orElse(defaultValue));
    }

    private <T> void record(T oldValue, T newValue) {
        if (this.active) {
            this.edited = this.edited || !oldValue.equals(newValue);
        }
    }
}

