/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.structure;

import com.castsoftware.sca.scar.server.orientdb.domain.NamedVertex;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.ClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.PropertyDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.lang.reflect.Constructor;
import java.util.Optional;

public class DelegateVClassDefinition
implements VClassDefinition {
    private final String name;
    private final Class<? extends Vertex<?>> domainType;
    private final Constructor<? extends Vertex<?>> domain;
    private final VClassDefinition parent;

    public DelegateVClassDefinition(String name, Class<? extends Vertex<?>> domain, VClassDefinition parent) {
        this.name = name;
        this.parent = parent;
        this.domainType = domain;
        this.domain = (Constructor)Optional.ofNullable(domain).map(Functions.forwardThrowable(c -> c.getDeclaredConstructor(OVertexDocument.class))).orElseThrow(IllegalArgumentException::new);
    }

    public <DOMAIN extends Vertex<?>> DOMAIN newInstance(OVertexDocument vertexDocument) {
        return (DOMAIN)((Vertex)Optional.ofNullable(vertexDocument).map(Functions.forwardThrowable(xva$0 -> (Vertex)this.domain.newInstance(xva$0))).orElseThrow(Suppliers.illegalArgument((String)"vertex document is mandatory")));
    }

    public String name() {
        return this.name;
    }

    public OClass describe(ODatabaseSession session) {
        String[] stringArray = new String[1];
        stringArray[0] = this.parent().map(ClassDefinition::name).orElseGet(() -> VClassDefinition.System.V.name());
        OClass clazz = session.createClassIfNotExist(this.name(), stringArray);
        if (NamedVertex.class.isAssignableFrom(this.domainType)) {
            PropertyDefinition.createNameProperty((OClass)clazz);
        }
        return clazz;
    }

    public Optional<VClassDefinition> parent() {
        return Optional.ofNullable(this.parent);
    }
}

