/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.structure;

import com.castsoftware.sca.scar.server.orientdb.domain.Document;
import com.castsoftware.sca.scar.server.orientdb.structure.ClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.DClassDefinition;
import com.castsoftware.sca.util.java.Functions;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.lang.reflect.Constructor;
import java.util.Optional;

public class DelegateDClassDefinition
implements DClassDefinition {
    private final String name;
    private final Constructor<? extends Document> domain;
    private final DClassDefinition parent;

    public DelegateDClassDefinition(String name, Class<? extends Document> domain, DClassDefinition parent) {
        this.name = name;
        this.parent = parent;
        this.domain = (Constructor)Optional.ofNullable(domain).map(Functions.forwardThrowable(c -> c.getDeclaredConstructor(ODocument.class))).orElseThrow(IllegalArgumentException::new);
    }

    public <DOMAIN extends Document> DOMAIN newInstance(ODocument document) {
        return (DOMAIN)((Document)Optional.ofNullable(document).map(Functions.forwardThrowable(xva$0 -> (Document)this.domain.newInstance(xva$0))).orElseThrow(Suppliers.illegalArgument((String)"document is mandatory")));
    }

    public String name() {
        return this.name;
    }

    public OClass describe(ODatabaseSession session) {
        return this.parent().map(p -> session.createClassIfNotExist(this.name(), new String[]{this.parent().map(ClassDefinition::name).get()})).orElseGet(() -> session.createClassIfNotExist(this.name(), new String[0]));
    }

    public Optional<DClassDefinition> parent() {
        return Optional.ofNullable(this.parent);
    }
}

