/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.domain;

import com.castsoftware.sca.scar.server.orientdb.domain.VertexVisitable;
import com.castsoftware.sca.scar.server.orientdb.domain.VertexVisitor;
import com.castsoftware.sca.scar.server.orientdb.structure.EditRecorder;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Vertex<VISITOR extends VertexVisitor>
implements Serializable,
VertexVisitable<VISITOR> {
    private final OVertexDocument vertex;
    private final EditRecorder editRecorder;

    protected Vertex() {
        this.vertex = new OVertexDocument();
        this.vertex.setClassName(this.definition().name());
        this.editRecorder = new EditRecorder();
    }

    protected Vertex(OVertexDocument vertex) {
        this.vertex = Optional.ofNullable(vertex).filter(v -> this.definition().name().equals(v.getClassName())).filter(arg_0 -> this.isValid(arg_0)).orElseThrow(Suppliers.illegalArgument((String)"invalid vertex or vertex type"));
        this.editRecorder = new EditRecorder();
    }

    public String getId() {
        return this.getORID().toString();
    }

    public ORID getORID() {
        return this.getVertex().getIdentity();
    }

    public final Boolean isValid() {
        return this.isValid(this.vertex) != false && this.definition().name().equals(this.vertex.getClassName());
    }

    public abstract VClassDefinition definition();

    public final OVertex getVertex() {
        return this.vertex;
    }

    public void recordEdit() {
        this.editRecorder.activate();
    }

    public boolean isContentEdited() {
        return this.editRecorder.isEdited();
    }

    public void setContentEdited() {
        this.editRecorder.setEdited();
    }

    private <T> Optional<T> getOptionalProperty(String property) {
        return Optional.ofNullable(property).map(arg_0 -> ((OVertexDocument)this.vertex).getProperty(arg_0));
    }

    protected EditRecorder getEditRecorder() {
        return this.editRecorder;
    }

    protected Boolean isValid(OVertexDocument vertex) {
        return true;
    }

    protected final <T> void setProperty(String property, T value) {
        this.setProperty(property, value, null);
    }

    protected final <T> void setProperty(String property, T value, Predicate<T> filter) {
        Optional.ofNullable(property).filter(Predicates.notEmptyString()).orElseThrow(IllegalArgumentException::new);
        Optional.ofNullable(value).filter(Optional.ofNullable(filter).orElseGet(() -> t -> true)).ifPresent(t -> this.vertex.setProperty(property, value));
    }

    protected final <T> T getPropertyOrNull(String property) {
        return (T)this.getProperty(property, null);
    }

    protected final <T> T getProperty(String property, T defaultValue) {
        return this.getOptionalProperty(property).orElse(defaultValue);
    }

    protected final <T> T getProperty(String property, Supplier<T> defaultValue) {
        return (T)this.getOptionalProperty(property).map(o -> o).orElseGet(() -> defaultValue != null ? defaultValue.get() : null);
    }
}

