/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.domain;

import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.util.visitable.SCArVertexVisitor;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Optional;

public abstract class NamedVertex
extends Vertex<SCArVertexVisitor> {
    public NamedVertex(String name) {
        this.getVertex().setProperty("name", (Object)Optional.ofNullable(name).filter(Predicates.notEmptyString()).orElseThrow(Suppliers.illegalArgument((String)"Name is mandatory and not empty on namedVertex")));
    }

    public NamedVertex(OVertexDocument vertex) {
        super(vertex);
    }

    public String getName() {
        return (String)this.getPropertyOrNull("name");
    }

    public void setName(String name) {
        this.getEditRecorder().record((Object)this.getName(), (Object)name, null);
        this.setProperty("name", (Object)name);
    }

    protected Boolean isValid(OVertexDocument vertex) {
        return Optional.ofNullable(vertex).filter(v -> v.getPropertyNames().contains("name")).isPresent();
    }
}

