/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.domain;

import com.castsoftware.sca.scar.server.orientdb.structure.DClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.EditRecorder;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Document
implements Serializable {
    private final ODocument document;
    private final EditRecorder editRecorder;

    protected Document() {
        this.document = new ODocument();
        this.document.setClassName(this.definition().name());
        this.editRecorder = new EditRecorder();
    }

    protected Document(ODocument document) {
        this.document = Optional.of(document).filter(d -> this.definition().name().equals(d.getClassName())).filter(arg_0 -> this.isValid(arg_0)).orElseThrow(Suppliers.illegalArgument((String)"invalid document or document type"));
        this.editRecorder = new EditRecorder();
    }

    public ODocument getDocument() {
        return this.document;
    }

    public EditRecorder getEditRecorder() {
        return this.editRecorder;
    }

    public void recordEdit() {
        this.editRecorder.activate();
    }

    public boolean isContentEdited() {
        return this.editRecorder.isEdited();
    }

    public void setContentEdited() {
        this.editRecorder.setEdited();
    }

    public String getId() {
        return this.getORID().toString();
    }

    public ORID getORID() {
        return this.getDocument().getIdentity();
    }

    public abstract DClassDefinition definition();

    public final Boolean isValid() {
        return this.isValid(this.document) != false && this.definition().name().equals(this.document.getClassName());
    }

    protected Boolean isValid(ODocument document) {
        return true;
    }

    protected final <T> T getPropertyOrNull(String property) {
        return (T)this.getProperty(property, null);
    }

    protected final <T> T getProperty(String property, T defaultValue) {
        return this.getOptionalProperty(property).orElse(defaultValue);
    }

    protected final <T> T getProperty(String property, Supplier<T> defaultValue) {
        return this.getOptionalProperty(property).orElseGet(defaultValue);
    }

    private <T> Optional<T> getOptionalProperty(String property) {
        return Optional.ofNullable(property).filter(this.document.getPropertyNames()::contains).map(arg_0 -> ((ODocument)this.document).getProperty(arg_0));
    }

    protected final <T> void setProperty(String property, T value) {
        this.setProperty(property, value, null);
    }

    protected final <T> void setProperty(String property, T value, Predicate<T> filter) {
        Optional.ofNullable(property).filter(Predicates.notEmptyString()).orElseThrow(IllegalArgumentException::new);
        Optional.ofNullable(value).filter(Optional.ofNullable(filter).orElseGet(() -> t -> true)).ifPresent(t -> this.document.setProperty(property, value));
    }
}

