/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.dao;

import com.castsoftware.sca.scar.server.orientdb.dao.BaseDao;
import com.castsoftware.sca.scar.server.orientdb.dao.GraphDao;
import com.castsoftware.sca.scar.server.orientdb.domain.Vertex;
import com.castsoftware.sca.scar.server.orientdb.structure.EClassDefinition;
import com.castsoftware.sca.scar.server.orientdb.structure.VClassDefinition;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.Predicates;
import com.castsoftware.sca.util.java.Suppliers;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.jooq.Query;
import org.jooq.SelectConditionStep;
import org.jooq.tools.StringUtils;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class GraphDao<DOMAIN extends Vertex<?>>
extends BaseDao {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(GraphDao.class);
    protected final VClassDefinition definition;

    public static String traverseOut(String from) {
        return GraphDao.traverseOut((String)from, (Integer)1);
    }

    public static String deleteVertex(Query from) {
        return GraphDao.deleteVertex((String)from.toString());
    }

    public static String deleteVertex(String from) {
        return GraphDao.deleteVertex((String)from, (boolean)true);
    }

    public static String deleteVertex(String from, boolean forFrom) {
        String toFormat = forFrom ? "delete vertex from (%s)" : "delete vertex from %s";
        return String.format(toFormat, from);
    }

    public static String traverseOut(String from, Integer maxDepth) {
        return GraphDao.traverseOut((String)from, (Integer)maxDepth, (boolean)true);
    }

    public static String traverseOut(String from, Integer maxDepth, boolean forFrom) {
        return GraphDao.traverse((String)TraverseType.OUT.value(new String[0]), (String)from, (Integer)maxDepth, (boolean)forFrom);
    }

    public static String traverseOutEdge(String from) {
        return GraphDao.traverseOutEdge((String)from, (Integer)1, (boolean)true);
    }

    public static String traverseOutEdge(String from, Integer maxDepth, boolean forFrom) {
        return GraphDao.traverse((String)TraverseType.OUT_EDGE.value(new String[0]), (String)from, (Integer)maxDepth, (boolean)forFrom);
    }

    public static String traverse(String projection, String from) {
        return GraphDao.traverse((String)projection, (String)from, (Integer)1);
    }

    public static String traverse(String projection, String from, Integer maxDepth) {
        return GraphDao.traverse((String)projection, (String)from, (Integer)maxDepth, (boolean)true);
    }

    public static String traverse(String projection, String from, Integer maxDepth, boolean forFrom) {
        return GraphDao.traverse(Collections.singletonList(projection), (String)from, (Integer)maxDepth, (boolean)forFrom);
    }

    public static String traverse(Collection<String> projections, String from) {
        return GraphDao.traverse(projections, (String)from, (Integer)1, (boolean)true);
    }

    public static String traverse(Collection<String> projections, String from, Integer maxdepth) {
        return GraphDao.traverse(projections, (String)from, (Integer)maxdepth, (boolean)true);
    }

    public static String traverse(Collection<String> projections, String from, Integer maxDepth, boolean forFrom) {
        String toFormat = "traverse %s from %s maxdepth %d";
        return String.format(forFrom ? "(".concat(toFormat).concat(")") : toFormat, Optional.ofNullable(projections).map(Collection::stream).map(s -> s.collect(Collectors.joining(","))).orElseThrow(IllegalArgumentException::new), Guards.notNull((Object)from, (Supplier)Suppliers.illegalArgument((String)"from is mandatory")), Objects.requireNonNullElse(maxDepth, 1));
    }

    public GraphDao(ODatabasePool oDatabasePool, VClassDefinition definition) {
        super(oDatabasePool);
        this.definition = (VClassDefinition)Guards.notNull((Object)definition, (Supplier)Suppliers.illegalArgument((String)"definition is mandatory"));
    }

    public List<DOMAIN> findAll() {
        return this.listDomain(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.queryBuilder.selectFrom(this.definition.name()), new Object[0]);
    }

    public List<DOMAIN> findAll(ODatabaseSession session) {
        return this.listDomain(session, arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)this.queryBuilder.selectFrom(this.definition.name()), new Object[0]);
    }

    public Optional<DOMAIN> findById(String id, ODatabaseSession session) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)id)) {
            SelectConditionStep query = this.queryBuilder.selectFrom(this.definition.name()).where(BaseDao.MetaFields.rid.eq((Object)id));
            return Optional.ofNullable(this.listDomain(session, arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), (Query)query, new Object[]{id})).filter(l -> l.size() == 1).map(Collection::stream).flatMap(Stream::findFirst);
        }
        return Optional.empty();
    }

    public Optional<DOMAIN> findById(String id) {
        return this.findById(id, null);
    }

    public DOMAIN save(DOMAIN toSave) {
        return (DOMAIN)this.save(toSave, null);
    }

    public DOMAIN save(DOMAIN toSave, ODatabaseSession existingSession) {
        return (DOMAIN)this.saveVertex((Vertex)Guards.notNull(toSave, (Supplier)Suppliers.illegalArgument((String)"element is mandatory")), arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), existingSession);
    }

    public void delete(DOMAIN toDelete) {
        this.delete(toDelete, null);
    }

    public void delete(DOMAIN toDelete, ODatabaseSession existingSession) {
        this.deleteVertex((Vertex)Guards.notNull(toDelete, (Supplier)Suppliers.illegalArgument((String)"element is mandatory")), existingSession);
    }

    public <TO extends Vertex<?>> void link(DOMAIN from, TO to, EClassDefinition type) {
        this.link(from, to, type, null, null);
    }

    public <TO extends Vertex<?>> void link(DOMAIN from, TO to, EClassDefinition type, ODatabaseSession existingSession) {
        this.link(from, to, type, null, existingSession);
    }

    public <TO extends Vertex<?>> void linkWithUpdate(DOMAIN from, TO to, EClassDefinition type, Consumer<OEdge> update) {
        this.linkWithUpdate(from, to, type, update, null);
    }

    public <TO extends Vertex<?>> void linkWithUpdate(DOMAIN from, TO to, EClassDefinition type, Consumer<OEdge> update, ODatabaseSession existingSession) {
        this.link(from, to, type, update, existingSession);
    }

    public <TO extends Vertex<?>> void link(DOMAIN from, TO to, EClassDefinition type, Consumer<OEdge> update, ODatabaseSession existingSession) {
        Guards.notNull(from, (Supplier)Suppliers.illegalArgument((String)"from vertex is mandatory"));
        Guards.notNull(to, (Supplier)Suppliers.illegalArgument((String)"to vertex is mandatory"));
        this.execute(session -> {
            OEdge edge = session.newEdge(this.refreshIfNecessary(from, existingSession, session).getVertex(), this.refreshIfNecessary(to, existingSession, session).getVertex(), Optional.ofNullable(type).orElse((EClassDefinition)EClassDefinition.System.E).name());
            Optional.ofNullable(update).ifPresent(u -> update.accept(edge));
            session.save((Object)edge);
        }, existingSession);
    }

    public <TO extends Vertex<?>> void unlink(DOMAIN from, TO to, EClassDefinition type) {
        this.unlink(from, to, type, null);
    }

    public <TO extends Vertex<?>> void unlink(DOMAIN from, TO to, EClassDefinition type, ODatabaseSession existingSession) {
        Guards.notNull((Object)type, (Supplier)Suppliers.illegalArgument((String)"Edge type is mandatory"));
        Guards.notNull(to, (Supplier)Suppliers.illegalArgument((String)"to vertex is mandatory"));
        this.unlink(from, Predicates.and((Predicate[])new Predicate[]{e -> e.getTo().getIdentity().toString().equals(to.getId()), e -> this.checkEdgeType(e, type)}), existingSession);
    }

    public void unlinkAll(DOMAIN from, EClassDefinition type, ODatabaseSession existingSession) {
        Guards.notNull((Object)type, (Supplier)Suppliers.illegalArgument((String)"Edge type is mandatory"));
        this.unlink(from, e -> this.checkEdgeType(e, type), existingSession);
    }

    public <TYPE> List<TYPE> listInEdge(Function<OEdge, TYPE> newInstance, String id, EClassDefinition edgeType) {
        SelectConditionStep query = this.queryBuilder.selectFrom(GraphDao.traverse((String)TraverseType.IN_EDGE.value(new String[0]), (String)id, (Integer)1, (boolean)true)).where(MetaFields.clazz.eq((Object)edgeType.name()));
        return this.listEdge(newInstance, (Query)query, new Object[]{edgeType.name()});
    }

    public <TYPE> List<TYPE> listEdge(Function<OEdge, TYPE> newInstance, Query query, Object ... args) {
        return this.listEdge(null, newInstance, query, args);
    }

    public <TYPE> List<TYPE> listEdge(ODatabaseSession existSession, Function<OEdge, TYPE> newInstance, Query query, Object ... args) {
        return (List)this.query(session -> session.query(query.getSQL(), args).edgeStream().map(newInstance).collect(Collectors.toList()), existSession);
    }

    public List<DOMAIN> listDomain(Function<OVertexDocument, DOMAIN> newInstance, Query query, Object ... args) {
        return this.listVertex(newInstance, query, args);
    }

    public List<DOMAIN> listDomain(ODatabaseSession existSession, Function<OVertexDocument, DOMAIN> newInstance, Query query, Object ... args) {
        return this.listVertex(existSession, newInstance, query.getSQL(), args);
    }

    public <VERTEX extends Vertex<?>> List<VERTEX> listVertex(Function<OVertexDocument, VERTEX> newInstance, Query query, Object ... args) {
        return this.listVertex(null, newInstance, query, args);
    }

    public <VERTEX extends Vertex<?>> List<VERTEX> listVertex(ODatabaseSession session, Function<OVertexDocument, VERTEX> newInstance, Query query, Object ... args) {
        return this.listVertex(session, newInstance, query.getSQL(), args);
    }

    public <VERTEX extends Vertex<?>> List<VERTEX> listVertex(Function<OVertexDocument, VERTEX> newInstance, String query) {
        return this.listVertex(null, newInstance, query, new Object[0]);
    }

    public List<DOMAIN> listByIndex(Function<OVertexDocument, DOMAIN> newInstance, String indexName, String keyValue) {
        return this.listIndex(newInstance, indexName, "'" + (String)Guards.notNull((Object)keyValue, (Supplier)Suppliers.illegalArgument((String)"Key value is mandatory")) + "'");
    }

    public boolean checkEdgeType(OEdge edge, EClassDefinition type) {
        return ((OClass)edge.getSchemaType().orElseThrow()).getName().equals(type.name()) || ((OClass)edge.getSchemaType().get()).isSubClassOf(type.name());
    }

    private List<DOMAIN> listIndex(Function<OVertexDocument, DOMAIN> newInstance, String indexName, String keyValue) {
        String query = String.format("select expand(rid) from INDEX:%s where key = %s", Guards.notNull((Object)indexName, (Supplier)Suppliers.illegalArgument((String)"index name is mandatory")), Guards.notNull((Object)keyValue, (Supplier)Suppliers.illegalArgument((String)"Key value is mandatory")));
        return this.listVertex(null, newInstance, query, new Object[0]);
    }

    private void unlink(DOMAIN from, Predicate<OEdge> unlinkRules, ODatabaseSession existingSession) {
        Guards.notNull(from, (Supplier)Suppliers.illegalArgument((String)"from vertex is mandatory"));
        this.execute(session -> StreamSupport.stream(this.refreshIfNecessary(from, existingSession, session).getVertex().getEdges(ODirection.OUT).spliterator(), false).filter(unlinkRules).forEach(arg_0 -> ((ODatabaseSession)session).delete(arg_0)), existingSession);
    }

    private <T extends Vertex<?>> T refreshIfNecessary(T vertex, ODatabaseSession existingSession, ODatabaseSession session) {
        return (T)Optional.of(vertex).filter(f -> !Objects.nonNull(existingSession)).orElseGet(() -> vertex.definition().newInstance((OVertexDocument)session.load(vertex.getORID())));
    }

    protected Optional<DOMAIN> findBy__(Query query) {
        return this.listVertex(arg_0 -> ((VClassDefinition)this.definition).newInstance(arg_0), query.toString()).stream().map(v -> v).findFirst();
    }

    protected <TYPE extends Vertex<?>> TYPE saveVertex(TYPE element, Function<OVertexDocument, TYPE> refresh) {
        return (TYPE)this.saveVertex(element, refresh, null);
    }

    protected <TYPE extends Vertex<?>> TYPE saveVertex(TYPE element, Function<OVertexDocument, TYPE> refresh, ODatabaseSession existingSession) {
        return (TYPE)((Vertex)this.query(session -> Optional.ofNullable(refresh).map(f -> (Vertex)f.apply((OVertexDocument)session.save((Object)element.getVertex()))).orElseGet(() -> {
            session.save((Object)element.getVertex());
            return element;
        }), existingSession));
    }

    protected <TYPE extends Vertex<?>> void deleteVertex(TYPE element, ODatabaseSession existingSession) {
        this.query(session -> session.delete(element.getORID()), existingSession);
    }

    protected List<DOMAIN> listDomain(ODatabaseSession existSession, Function<OVertexDocument, DOMAIN> newInstance, String query, Object ... args) {
        return this.listVertex(existSession, newInstance, query, args);
    }

    protected <VERTEX extends Vertex<?>> List<VERTEX> listVertex(ODatabaseSession existSession, Function<OVertexDocument, VERTEX> newInstance, String query, Object ... args) {
        return (List)this.query(session -> session.query(query, args).vertexStream().map(OVertexDocument.class::cast).map(v -> {
            try {
                return Optional.of((Vertex)newInstance.apply((OVertexDocument)v));
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
        }).filter(Optional::isPresent).map(Optional::get).filter(Vertex::isValid).collect(Collectors.toList()), existSession);
    }

    protected Predicate<OVertexDocument> checkType(String className) {
        return oVertexDocument -> Optional.ofNullable(oVertexDocument).map(ODocument::getClassName).filter(s -> s.equals(StringUtils.defaultIfBlank((String)className, null))).isPresent();
    }
}

