/*
 * Decompiled with CFR 0.152.
 */
package com.castsoftware.sca.scar.server.orientdb.dao;

import com.castsoftware.sca.scar.server.orientdb.exception.ConcurrencyConflictException;
import com.castsoftware.sca.util.java.Guards;
import com.castsoftware.sca.util.java.exception.Exceptions;
import com.castsoftware.sca.util.java.log.ScaLoggerFactory;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.slf4j.Logger;

public class BaseDao {
    @Generated
    private static final Logger LOGGER = ScaLoggerFactory.getLogger(BaseDao.class);
    protected final DSLContext queryBuilder = DSL.using((SQLDialect)SQLDialect.MYSQL);
    private final ODatabasePool pool;

    public BaseDao(ODatabasePool pool) {
        this.pool = pool;
    }

    public <T> T query(Function<ODatabaseSession, T> fetching) {
        return (T)this.query(fetching, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T query(Function<ODatabaseSession, T> fetching, ODatabaseSession session) {
        Guards.notNull(fetching);
        if (session != null) {
            return (T)fetching.apply(session);
        }
        try (ODatabaseSession connection = this.pool.acquire();){
            ODatabaseSession t = fetching.apply(connection);
            return (T)t;
        }
        catch (Throwable throwable3) {
            LOGGER.error(String.format("Failed to perform OrientDb fetch: %s", StringUtils.defaultIfBlank((CharSequence)throwable3.getMessage(), (CharSequence)"Unknown error!")));
            throw this.mapException(throwable3);
        }
    }

    public <T> T getWithTransaction(Function<ODatabaseSession, T> functionToExecute) {
        Guards.notNull(functionToExecute);
        return (T)this.query(session -> {
            session.begin();
            try {
                Object result = functionToExecute.apply((ODatabaseSession)session);
                session.commit();
                return result;
            }
            catch (Throwable throwable) {
                session.rollback();
                LOGGER.error(String.format("Failed to execute transactional query. Rollback is performed: %s", StringUtils.defaultIfBlank((CharSequence)throwable.getMessage(), (CharSequence)"Unknown error!")));
                throw Exceptions.wrap((Throwable)throwable);
            }
        });
    }

    public void execute(Consumer<ODatabaseSession> executing) {
        this.execute(executing, null);
    }

    public void execute(Consumer<ODatabaseSession> executing, ODatabaseSession session) {
        Guards.notNull(executing);
        if (session != null) {
            executing.accept(session);
            return;
        }
        try (ODatabaseSession connection = this.pool.acquire();){
            executing.accept(connection);
        }
        catch (Throwable throwable) {
            LOGGER.error(String.format("Failed to perform OrientDb execute: %s", StringUtils.defaultIfBlank((CharSequence)throwable.getMessage(), (CharSequence)"Unknown error!")));
            throw this.mapException(throwable);
        }
    }

    public void withTransaction(Consumer<ODatabaseSession> consumer) {
        if (consumer == null) {
            return;
        }
        this.execute(session -> {
            session.begin();
            try {
                consumer.accept((ODatabaseSession)session);
                session.commit();
            }
            catch (Throwable throwable) {
                session.rollback();
                LOGGER.error(String.format("Failed to execute transactional query. Rollback is performed: %s", StringUtils.defaultIfBlank((CharSequence)throwable.getMessage(), (CharSequence)"Unknown error!")));
                throw Exceptions.wrap((Throwable)throwable);
            }
        });
    }

    private RuntimeException mapException(Throwable throwable) {
        if (throwable instanceof OConcurrentModificationException) {
            return new ConcurrencyConflictException((OConcurrentModificationException)throwable);
        }
        return Exceptions.wrap((Throwable)throwable);
    }
}

